/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VMExtension
implements JsonSerializable<VMExtension> {
    private final String name;
    private final String publisher;
    private final String type;
    private String typeHandlerVersion;
    private Boolean autoUpgradeMinorVersion;
    private Boolean enableAutomaticUpgrade;
    private Map<String, String> settings;
    private Map<String, String> protectedSettings;
    private List<String> provisionAfterExtensions;

    public VMExtension(String name, String publisher, String type) {
        this.name = name;
        this.publisher = publisher;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeHandlerVersion() {
        return this.typeHandlerVersion;
    }

    public VMExtension setTypeHandlerVersion(String typeHandlerVersion) {
        this.typeHandlerVersion = typeHandlerVersion;
        return this;
    }

    public Boolean isAutoUpgradeMinorVersion() {
        return this.autoUpgradeMinorVersion;
    }

    public VMExtension setAutoUpgradeMinorVersion(Boolean autoUpgradeMinorVersion) {
        this.autoUpgradeMinorVersion = autoUpgradeMinorVersion;
        return this;
    }

    public Boolean isEnableAutomaticUpgrade() {
        return this.enableAutomaticUpgrade;
    }

    public VMExtension setEnableAutomaticUpgrade(Boolean enableAutomaticUpgrade) {
        this.enableAutomaticUpgrade = enableAutomaticUpgrade;
        return this;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public VMExtension setSettings(Map<String, String> settings) {
        this.settings = settings;
        return this;
    }

    public Map<String, String> getProtectedSettings() {
        return this.protectedSettings;
    }

    public VMExtension setProtectedSettings(Map<String, String> protectedSettings) {
        this.protectedSettings = protectedSettings;
        return this;
    }

    public List<String> getProvisionAfterExtensions() {
        return this.provisionAfterExtensions;
    }

    public VMExtension setProvisionAfterExtensions(List<String> provisionAfterExtensions) {
        this.provisionAfterExtensions = provisionAfterExtensions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("publisher", this.publisher);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("typeHandlerVersion", this.typeHandlerVersion);
        jsonWriter.writeBooleanField("autoUpgradeMinorVersion", this.autoUpgradeMinorVersion);
        jsonWriter.writeBooleanField("enableAutomaticUpgrade", this.enableAutomaticUpgrade);
        jsonWriter.writeMapField("settings", this.settings, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("protectedSettings", this.protectedSettings, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("provisionAfterExtensions", this.provisionAfterExtensions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VMExtension fromJson(JsonReader jsonReader) throws IOException {
        return (VMExtension)jsonReader.readObject(reader -> {
            String name = null;
            String publisher = null;
            String type = null;
            String typeHandlerVersion = null;
            Boolean autoUpgradeMinorVersion = null;
            Boolean enableAutomaticUpgrade = null;
            Map settings = null;
            Map protectedSettings = null;
            List provisionAfterExtensions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("publisher".equals(fieldName)) {
                    publisher = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("typeHandlerVersion".equals(fieldName)) {
                    typeHandlerVersion = reader.getString();
                    continue;
                }
                if ("autoUpgradeMinorVersion".equals(fieldName)) {
                    autoUpgradeMinorVersion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticUpgrade".equals(fieldName)) {
                    enableAutomaticUpgrade = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    settings = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("protectedSettings".equals(fieldName)) {
                    protectedSettings = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisionAfterExtensions".equals(fieldName)) {
                    provisionAfterExtensions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            VMExtension deserializedVMExtension = new VMExtension(name, publisher, type);
            deserializedVMExtension.typeHandlerVersion = typeHandlerVersion;
            deserializedVMExtension.autoUpgradeMinorVersion = autoUpgradeMinorVersion;
            deserializedVMExtension.enableAutomaticUpgrade = enableAutomaticUpgrade;
            deserializedVMExtension.settings = settings;
            deserializedVMExtension.protectedSettings = protectedSettings;
            deserializedVMExtension.provisionAfterExtensions = provisionAfterExtensions;
            return deserializedVMExtension;
        });
    }
}

