/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ElevationLevel;
import com.azure.compute.batch.models.LinuxUserConfiguration;
import com.azure.compute.batch.models.WindowsUserConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class UserAccount
implements JsonSerializable<UserAccount> {
    private final String name;
    private final String password;
    private ElevationLevel elevationLevel;
    private LinuxUserConfiguration linuxUserConfiguration;
    private WindowsUserConfiguration windowsUserConfiguration;

    public UserAccount(String name, String password) {
        this.name = name;
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public ElevationLevel getElevationLevel() {
        return this.elevationLevel;
    }

    public UserAccount setElevationLevel(ElevationLevel elevationLevel) {
        this.elevationLevel = elevationLevel;
        return this;
    }

    public LinuxUserConfiguration getLinuxUserConfiguration() {
        return this.linuxUserConfiguration;
    }

    public UserAccount setLinuxUserConfiguration(LinuxUserConfiguration linuxUserConfiguration) {
        this.linuxUserConfiguration = linuxUserConfiguration;
        return this;
    }

    public WindowsUserConfiguration getWindowsUserConfiguration() {
        return this.windowsUserConfiguration;
    }

    public UserAccount setWindowsUserConfiguration(WindowsUserConfiguration windowsUserConfiguration) {
        this.windowsUserConfiguration = windowsUserConfiguration;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("elevationLevel", this.elevationLevel == null ? null : this.elevationLevel.toString());
        jsonWriter.writeJsonField("linuxUserConfiguration", (JsonSerializable)this.linuxUserConfiguration);
        jsonWriter.writeJsonField("windowsUserConfiguration", (JsonSerializable)this.windowsUserConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static UserAccount fromJson(JsonReader jsonReader) throws IOException {
        return (UserAccount)jsonReader.readObject(reader -> {
            String name = null;
            String password = null;
            ElevationLevel elevationLevel = null;
            LinuxUserConfiguration linuxUserConfiguration = null;
            WindowsUserConfiguration windowsUserConfiguration = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    password = reader.getString();
                    continue;
                }
                if ("elevationLevel".equals(fieldName)) {
                    elevationLevel = ElevationLevel.fromString(reader.getString());
                    continue;
                }
                if ("linuxUserConfiguration".equals(fieldName)) {
                    linuxUserConfiguration = LinuxUserConfiguration.fromJson(reader);
                    continue;
                }
                if ("windowsUserConfiguration".equals(fieldName)) {
                    windowsUserConfiguration = WindowsUserConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            UserAccount deserializedUserAccount = new UserAccount(name, password);
            deserializedUserAccount.elevationLevel = elevationLevel;
            deserializedUserAccount.linuxUserConfiguration = linuxUserConfiguration;
            deserializedUserAccount.windowsUserConfiguration = windowsUserConfiguration;
            return deserializedUserAccount;
        });
    }
}

