/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.NameValuePair;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResizeError
implements JsonSerializable<ResizeError> {
    private String code;
    private String message;
    private List<NameValuePair> values;

    private ResizeError() {
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public List<NameValuePair> getValues() {
        return this.values;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResizeError fromJson(JsonReader jsonReader) throws IOException {
        return (ResizeError)jsonReader.readObject(reader -> {
            ResizeError deserializedResizeError = new ResizeError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedResizeError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedResizeError.message = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedResizeError.values = values = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResizeError;
        });
    }
}

