/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeIdentityReference;
import com.azure.compute.batch.models.HttpHeader;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class OutputFileBlobContainerDestination
implements JsonSerializable<OutputFileBlobContainerDestination> {
    private String path;
    private final String containerUrl;
    private BatchNodeIdentityReference identityReference;
    private List<HttpHeader> uploadHeaders;

    public OutputFileBlobContainerDestination(String containerUrl) {
        this.containerUrl = containerUrl;
    }

    public String getPath() {
        return this.path;
    }

    public OutputFileBlobContainerDestination setPath(String path) {
        this.path = path;
        return this;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public BatchNodeIdentityReference getIdentityReference() {
        return this.identityReference;
    }

    public OutputFileBlobContainerDestination setIdentityReference(BatchNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public List<HttpHeader> getUploadHeaders() {
        return this.uploadHeaders;
    }

    public OutputFileBlobContainerDestination setUploadHeaders(List<HttpHeader> uploadHeaders) {
        this.uploadHeaders = uploadHeaders;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerUrl", this.containerUrl);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeJsonField("identityReference", (JsonSerializable)this.identityReference);
        jsonWriter.writeArrayField("uploadHeaders", this.uploadHeaders, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OutputFileBlobContainerDestination fromJson(JsonReader jsonReader) throws IOException {
        return (OutputFileBlobContainerDestination)jsonReader.readObject(reader -> {
            String containerUrl = null;
            String path = null;
            BatchNodeIdentityReference identityReference = null;
            List uploadHeaders = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerUrl".equals(fieldName)) {
                    containerUrl = reader.getString();
                    continue;
                }
                if ("path".equals(fieldName)) {
                    path = reader.getString();
                    continue;
                }
                if ("identityReference".equals(fieldName)) {
                    identityReference = BatchNodeIdentityReference.fromJson(reader);
                    continue;
                }
                if ("uploadHeaders".equals(fieldName)) {
                    uploadHeaders = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            OutputFileBlobContainerDestination deserializedOutputFileBlobContainerDestination = new OutputFileBlobContainerDestination(containerUrl);
            deserializedOutputFileBlobContainerDestination.path = path;
            deserializedOutputFileBlobContainerDestination.identityReference = identityReference;
            deserializedOutputFileBlobContainerDestination.uploadHeaders = uploadHeaders;
            return deserializedOutputFileBlobContainerDestination;
        });
    }
}

