/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.CachingType;
import com.azure.compute.batch.models.DiffDiskSettings;
import com.azure.compute.batch.models.ManagedDisk;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OSDisk
implements JsonSerializable<OSDisk> {
    private DiffDiskSettings ephemeralOSDiskSettings;
    private CachingType caching;
    private Integer diskSizeGB;
    private ManagedDisk managedDisk;
    private Boolean writeAcceleratorEnabled;

    public DiffDiskSettings getEphemeralOSDiskSettings() {
        return this.ephemeralOSDiskSettings;
    }

    public OSDisk setEphemeralOSDiskSettings(DiffDiskSettings ephemeralOSDiskSettings) {
        this.ephemeralOSDiskSettings = ephemeralOSDiskSettings;
        return this;
    }

    public CachingType getCaching() {
        return this.caching;
    }

    public OSDisk setCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

    public Integer getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public OSDisk setDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public ManagedDisk getManagedDisk() {
        return this.managedDisk;
    }

    public OSDisk setManagedDisk(ManagedDisk managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public Boolean isWriteAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public OSDisk setWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("ephemeralOSDiskSettings", (JsonSerializable)this.ephemeralOSDiskSettings);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        return jsonWriter.writeEndObject();
    }

    public static OSDisk fromJson(JsonReader jsonReader) throws IOException {
        return (OSDisk)jsonReader.readObject(reader -> {
            OSDisk deserializedOSDisk = new OSDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ephemeralOSDiskSettings".equals(fieldName)) {
                    deserializedOSDisk.ephemeralOSDiskSettings = DiffDiskSettings.fromJson(reader);
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedOSDisk.caching = CachingType.fromString(reader.getString());
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedOSDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedOSDisk.managedDisk = ManagedDisk.fromJson(reader);
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedOSDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOSDisk;
        });
    }
}

