/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class NfsMountConfiguration
implements JsonSerializable<NfsMountConfiguration> {
    private final String source;
    private final String relativeMountPath;
    private String mountOptions;

    public NfsMountConfiguration(String source, String relativeMountPath) {
        this.source = source;
        this.relativeMountPath = relativeMountPath;
    }

    public String getSource() {
        return this.source;
    }

    public String getRelativeMountPath() {
        return this.relativeMountPath;
    }

    public String getMountOptions() {
        return this.mountOptions;
    }

    public NfsMountConfiguration setMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    public static NfsMountConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (NfsMountConfiguration)jsonReader.readObject(reader -> {
            String source = null;
            String relativeMountPath = null;
            String mountOptions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    source = reader.getString();
                    continue;
                }
                if ("relativeMountPath".equals(fieldName)) {
                    relativeMountPath = reader.getString();
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    mountOptions = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            NfsMountConfiguration deserializedNfsMountConfiguration = new NfsMountConfiguration(source, relativeMountPath);
            deserializedNfsMountConfiguration.mountOptions = mountOptions;
            return deserializedNfsMountConfiguration;
        });
    }
}

