/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ResourceFile;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MultiInstanceSettings
implements JsonSerializable<MultiInstanceSettings> {
    private Integer numberOfInstances;
    private final String coordinationCommandLine;
    private List<ResourceFile> commonResourceFiles;

    public MultiInstanceSettings(String coordinationCommandLine) {
        this.coordinationCommandLine = coordinationCommandLine;
    }

    public Integer getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public MultiInstanceSettings setNumberOfInstances(Integer numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
        return this;
    }

    public String getCoordinationCommandLine() {
        return this.coordinationCommandLine;
    }

    public List<ResourceFile> getCommonResourceFiles() {
        return this.commonResourceFiles;
    }

    public MultiInstanceSettings setCommonResourceFiles(List<ResourceFile> commonResourceFiles) {
        this.commonResourceFiles = commonResourceFiles;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("coordinationCommandLine", this.coordinationCommandLine);
        jsonWriter.writeNumberField("numberOfInstances", (Number)this.numberOfInstances);
        jsonWriter.writeArrayField("commonResourceFiles", this.commonResourceFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MultiInstanceSettings fromJson(JsonReader jsonReader) throws IOException {
        return (MultiInstanceSettings)jsonReader.readObject(reader -> {
            String coordinationCommandLine = null;
            Integer numberOfInstances = null;
            List commonResourceFiles = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("coordinationCommandLine".equals(fieldName)) {
                    coordinationCommandLine = reader.getString();
                    continue;
                }
                if ("numberOfInstances".equals(fieldName)) {
                    numberOfInstances = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("commonResourceFiles".equals(fieldName)) {
                    commonResourceFiles = reader.readArray(reader1 -> ResourceFile.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            MultiInstanceSettings deserializedMultiInstanceSettings = new MultiInstanceSettings(coordinationCommandLine);
            deserializedMultiInstanceSettings.numberOfInstances = numberOfInstances;
            deserializedMultiInstanceSettings.commonResourceFiles = commonResourceFiles;
            return deserializedMultiInstanceSettings;
        });
    }
}

