/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.StatusLevelTypes;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class InstanceViewStatus
implements JsonSerializable<InstanceViewStatus> {
    private String code;
    private String displayStatus;
    private StatusLevelTypes level;
    private String message;
    private OffsetDateTime time;

    private InstanceViewStatus() {
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplayStatus() {
        return this.displayStatus;
    }

    public StatusLevelTypes getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("displayStatus", this.displayStatus);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        return jsonWriter.writeEndObject();
    }

    public static InstanceViewStatus fromJson(JsonReader jsonReader) throws IOException {
        return (InstanceViewStatus)jsonReader.readObject(reader -> {
            InstanceViewStatus deserializedInstanceViewStatus = new InstanceViewStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedInstanceViewStatus.code = reader.getString();
                    continue;
                }
                if ("displayStatus".equals(fieldName)) {
                    deserializedInstanceViewStatus.displayStatus = reader.getString();
                    continue;
                }
                if ("level".equals(fieldName)) {
                    deserializedInstanceViewStatus.level = StatusLevelTypes.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedInstanceViewStatus.message = reader.getString();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedInstanceViewStatus.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstanceViewStatus;
        });
    }
}

