/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class FileProperties
implements JsonSerializable<FileProperties> {
    private OffsetDateTime creationTime;
    private final OffsetDateTime lastModified;
    private final long contentLength;
    private String contentType;
    private String fileMode;

    private FileProperties(OffsetDateTime lastModified, long contentLength) {
        this.lastModified = lastModified;
        this.contentLength = contentLength;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastModified", this.lastModified == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModified));
        jsonWriter.writeStringField("contentLength", Objects.toString(this.contentLength, null));
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("fileMode", this.fileMode);
        return jsonWriter.writeEndObject();
    }

    public static FileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FileProperties)jsonReader.readObject(reader -> {
            OffsetDateTime lastModified = null;
            long contentLength = Long.parseLong("0");
            OffsetDateTime creationTime = null;
            String contentType = null;
            String fileMode = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastModified".equals(fieldName)) {
                    lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("contentLength".equals(fieldName)) {
                    contentLength = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    contentType = reader.getString();
                    continue;
                }
                if ("fileMode".equals(fieldName)) {
                    fileMode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            FileProperties deserializedFileProperties = new FileProperties(lastModified, contentLength);
            deserializedFileProperties.creationTime = creationTime;
            deserializedFileProperties.contentType = contentType;
            deserializedFileProperties.fileMode = fileMode;
            return deserializedFileProperties;
        });
    }
}

