/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ExitCodeMapping;
import com.azure.compute.batch.models.ExitCodeRangeMapping;
import com.azure.compute.batch.models.ExitOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ExitConditions
implements JsonSerializable<ExitConditions> {
    private List<ExitCodeMapping> exitCodes;
    private List<ExitCodeRangeMapping> exitCodeRanges;
    private ExitOptions preProcessingError;
    private ExitOptions fileUploadError;
    private ExitOptions defaultProperty;

    public List<ExitCodeMapping> getExitCodes() {
        return this.exitCodes;
    }

    public ExitConditions setExitCodes(List<ExitCodeMapping> exitCodes) {
        this.exitCodes = exitCodes;
        return this;
    }

    public List<ExitCodeRangeMapping> getExitCodeRanges() {
        return this.exitCodeRanges;
    }

    public ExitConditions setExitCodeRanges(List<ExitCodeRangeMapping> exitCodeRanges) {
        this.exitCodeRanges = exitCodeRanges;
        return this;
    }

    public ExitOptions getPreProcessingError() {
        return this.preProcessingError;
    }

    public ExitConditions setPreProcessingError(ExitOptions preProcessingError) {
        this.preProcessingError = preProcessingError;
        return this;
    }

    public ExitOptions getFileUploadError() {
        return this.fileUploadError;
    }

    public ExitConditions setFileUploadError(ExitOptions fileUploadError) {
        this.fileUploadError = fileUploadError;
        return this;
    }

    public ExitOptions getDefaultProperty() {
        return this.defaultProperty;
    }

    public ExitConditions setDefaultProperty(ExitOptions defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("exitCodes", this.exitCodes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("exitCodeRanges", this.exitCodeRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("preProcessingError", (JsonSerializable)this.preProcessingError);
        jsonWriter.writeJsonField("fileUploadError", (JsonSerializable)this.fileUploadError);
        jsonWriter.writeJsonField("default", (JsonSerializable)this.defaultProperty);
        return jsonWriter.writeEndObject();
    }

    public static ExitConditions fromJson(JsonReader jsonReader) throws IOException {
        return (ExitConditions)jsonReader.readObject(reader -> {
            ExitConditions deserializedExitConditions = new ExitConditions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("exitCodes".equals(fieldName)) {
                    List exitCodes;
                    deserializedExitConditions.exitCodes = exitCodes = reader.readArray(reader1 -> ExitCodeMapping.fromJson(reader1));
                    continue;
                }
                if ("exitCodeRanges".equals(fieldName)) {
                    List exitCodeRanges;
                    deserializedExitConditions.exitCodeRanges = exitCodeRanges = reader.readArray(reader1 -> ExitCodeRangeMapping.fromJson(reader1));
                    continue;
                }
                if ("preProcessingError".equals(fieldName)) {
                    deserializedExitConditions.preProcessingError = ExitOptions.fromJson(reader);
                    continue;
                }
                if ("fileUploadError".equals(fieldName)) {
                    deserializedExitConditions.fileUploadError = ExitOptions.fromJson(reader);
                    continue;
                }
                if ("default".equals(fieldName)) {
                    deserializedExitConditions.defaultProperty = ExitOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExitConditions;
        });
    }
}

