/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ContainerRegistryReference;
import com.azure.compute.batch.models.ContainerType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ContainerConfiguration
implements JsonSerializable<ContainerConfiguration> {
    private final ContainerType type;
    private List<String> containerImageNames;
    private List<ContainerRegistryReference> containerRegistries;

    public ContainerConfiguration(ContainerType type) {
        this.type = type;
    }

    public ContainerType getType() {
        return this.type;
    }

    public List<String> getContainerImageNames() {
        return this.containerImageNames;
    }

    public ContainerConfiguration setContainerImageNames(List<String> containerImageNames) {
        this.containerImageNames = containerImageNames;
        return this;
    }

    public List<ContainerRegistryReference> getContainerRegistries() {
        return this.containerRegistries;
    }

    public ContainerConfiguration setContainerRegistries(List<ContainerRegistryReference> containerRegistries) {
        this.containerRegistries = containerRegistries;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("containerImageNames", this.containerImageNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("containerRegistries", this.containerRegistries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ContainerConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerConfiguration)jsonReader.readObject(reader -> {
            ContainerType type = null;
            List containerImageNames = null;
            List containerRegistries = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = ContainerType.fromString(reader.getString());
                    continue;
                }
                if ("containerImageNames".equals(fieldName)) {
                    containerImageNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("containerRegistries".equals(fieldName)) {
                    containerRegistries = reader.readArray(reader1 -> ContainerRegistryReference.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            ContainerConfiguration deserializedContainerConfiguration = new ContainerConfiguration(type);
            deserializedContainerConfiguration.containerImageNames = containerImageNames;
            deserializedContainerConfiguration.containerRegistries = containerRegistries;
            return deserializedContainerConfiguration;
        });
    }
}

