/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CifsMountConfiguration
implements JsonSerializable<CifsMountConfiguration> {
    private final String username;
    private final String source;
    private final String relativeMountPath;
    private String mountOptions;
    private final String password;

    public CifsMountConfiguration(String username, String source, String relativeMountPath, String password) {
        this.username = username;
        this.source = source;
        this.relativeMountPath = relativeMountPath;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSource() {
        return this.source;
    }

    public String getRelativeMountPath() {
        return this.relativeMountPath;
    }

    public String getMountOptions() {
        return this.mountOptions;
    }

    public CifsMountConfiguration setMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    public static CifsMountConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (CifsMountConfiguration)jsonReader.readObject(reader -> {
            String username = null;
            String source = null;
            String relativeMountPath = null;
            String password = null;
            String mountOptions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    username = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    source = reader.getString();
                    continue;
                }
                if ("relativeMountPath".equals(fieldName)) {
                    relativeMountPath = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    password = reader.getString();
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    mountOptions = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            CifsMountConfiguration deserializedCifsMountConfiguration = new CifsMountConfiguration(username, source, relativeMountPath, password);
            deserializedCifsMountConfiguration.mountOptions = mountOptions;
            return deserializedCifsMountConfiguration;
        });
    }
}

