/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchTaskCounts
implements JsonSerializable<BatchTaskCounts> {
    private final int active;
    private final int running;
    private final int completed;
    private final int succeeded;
    private final int failed;

    private BatchTaskCounts(int active, int running, int completed, int succeeded, int failed) {
        this.active = active;
        this.running = running;
        this.completed = completed;
        this.succeeded = succeeded;
        this.failed = failed;
    }

    public int getActive() {
        return this.active;
    }

    public int getRunning() {
        return this.running;
    }

    public int getCompleted() {
        return this.completed;
    }

    public int getSucceeded() {
        return this.succeeded;
    }

    public int getFailed() {
        return this.failed;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("active", this.active);
        jsonWriter.writeIntField("running", this.running);
        jsonWriter.writeIntField("completed", this.completed);
        jsonWriter.writeIntField("succeeded", this.succeeded);
        jsonWriter.writeIntField("failed", this.failed);
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskCounts fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskCounts)jsonReader.readObject(reader -> {
            int active = 0;
            int running = 0;
            int completed = 0;
            int succeeded = 0;
            int failed = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("active".equals(fieldName)) {
                    active = reader.getInt();
                    continue;
                }
                if ("running".equals(fieldName)) {
                    running = reader.getInt();
                    continue;
                }
                if ("completed".equals(fieldName)) {
                    completed = reader.getInt();
                    continue;
                }
                if ("succeeded".equals(fieldName)) {
                    succeeded = reader.getInt();
                    continue;
                }
                if ("failed".equals(fieldName)) {
                    failed = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchTaskCounts(active, running, completed, succeeded, failed);
        });
    }
}

