/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ContainerHostBatchBindMountEntry;
import com.azure.compute.batch.models.ContainerRegistryReference;
import com.azure.compute.batch.models.ContainerWorkingDirectory;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchTaskContainerSettings
implements JsonSerializable<BatchTaskContainerSettings> {
    private String containerRunOptions;
    private final String imageName;
    private ContainerRegistryReference registry;
    private ContainerWorkingDirectory workingDirectory;
    private List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts;

    public BatchTaskContainerSettings(String imageName) {
        this.imageName = imageName;
    }

    public String getContainerRunOptions() {
        return this.containerRunOptions;
    }

    public BatchTaskContainerSettings setContainerRunOptions(String containerRunOptions) {
        this.containerRunOptions = containerRunOptions;
        return this;
    }

    public String getImageName() {
        return this.imageName;
    }

    public ContainerRegistryReference getRegistry() {
        return this.registry;
    }

    public BatchTaskContainerSettings setRegistry(ContainerRegistryReference registry) {
        this.registry = registry;
        return this;
    }

    public ContainerWorkingDirectory getWorkingDirectory() {
        return this.workingDirectory;
    }

    public BatchTaskContainerSettings setWorkingDirectory(ContainerWorkingDirectory workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public List<ContainerHostBatchBindMountEntry> getContainerHostBatchBindMounts() {
        return this.containerHostBatchBindMounts;
    }

    public BatchTaskContainerSettings setContainerHostBatchBindMounts(List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts) {
        this.containerHostBatchBindMounts = containerHostBatchBindMounts;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("imageName", this.imageName);
        jsonWriter.writeStringField("containerRunOptions", this.containerRunOptions);
        jsonWriter.writeJsonField("registry", (JsonSerializable)this.registry);
        jsonWriter.writeStringField("workingDirectory", this.workingDirectory == null ? null : this.workingDirectory.toString());
        jsonWriter.writeArrayField("containerHostBatchBindMounts", this.containerHostBatchBindMounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskContainerSettings fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskContainerSettings)jsonReader.readObject(reader -> {
            String imageName = null;
            String containerRunOptions = null;
            ContainerRegistryReference registry = null;
            ContainerWorkingDirectory workingDirectory = null;
            List containerHostBatchBindMounts = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageName".equals(fieldName)) {
                    imageName = reader.getString();
                    continue;
                }
                if ("containerRunOptions".equals(fieldName)) {
                    containerRunOptions = reader.getString();
                    continue;
                }
                if ("registry".equals(fieldName)) {
                    registry = ContainerRegistryReference.fromJson(reader);
                    continue;
                }
                if ("workingDirectory".equals(fieldName)) {
                    workingDirectory = ContainerWorkingDirectory.fromString(reader.getString());
                    continue;
                }
                if ("containerHostBatchBindMounts".equals(fieldName)) {
                    containerHostBatchBindMounts = reader.readArray(reader1 -> ContainerHostBatchBindMountEntry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            BatchTaskContainerSettings deserializedBatchTaskContainerSettings = new BatchTaskContainerSettings(imageName);
            deserializedBatchTaskContainerSettings.containerRunOptions = containerRunOptions;
            deserializedBatchTaskContainerSettings.registry = registry;
            deserializedBatchTaskContainerSettings.workingDirectory = workingDirectory;
            deserializedBatchTaskContainerSettings.containerHostBatchBindMounts = containerHostBatchBindMounts;
            return deserializedBatchTaskContainerSettings;
        });
    }
}

