/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ImageReference;
import com.azure.compute.batch.models.ImageVerificationType;
import com.azure.compute.batch.models.OSType;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class BatchSupportedImage
implements JsonSerializable<BatchSupportedImage> {
    private final String nodeAgentSkuId;
    private final ImageReference imageReference;
    private final OSType osType;
    private List<String> capabilities;
    private OffsetDateTime batchSupportEndOfLife;
    private final ImageVerificationType verificationType;

    private BatchSupportedImage(String nodeAgentSkuId, ImageReference imageReference, OSType osType, ImageVerificationType verificationType) {
        this.nodeAgentSkuId = nodeAgentSkuId;
        this.imageReference = imageReference;
        this.osType = osType;
        this.verificationType = verificationType;
    }

    public String getNodeAgentSkuId() {
        return this.nodeAgentSkuId;
    }

    public ImageReference getImageReference() {
        return this.imageReference;
    }

    public OSType getOsType() {
        return this.osType;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public OffsetDateTime getBatchSupportEndOfLife() {
        return this.batchSupportEndOfLife;
    }

    public ImageVerificationType getVerificationType() {
        return this.verificationType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nodeAgentSKUId", this.nodeAgentSkuId);
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("verificationType", this.verificationType == null ? null : this.verificationType.toString());
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("batchSupportEndOfLife", this.batchSupportEndOfLife == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.batchSupportEndOfLife));
        return jsonWriter.writeEndObject();
    }

    public static BatchSupportedImage fromJson(JsonReader jsonReader) throws IOException {
        return (BatchSupportedImage)jsonReader.readObject(reader -> {
            String nodeAgentSkuId = null;
            ImageReference imageReference = null;
            OSType osType = null;
            ImageVerificationType verificationType = null;
            List capabilities = null;
            OffsetDateTime batchSupportEndOfLife = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nodeAgentSKUId".equals(fieldName)) {
                    nodeAgentSkuId = reader.getString();
                    continue;
                }
                if ("imageReference".equals(fieldName)) {
                    imageReference = ImageReference.fromJson(reader);
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    osType = OSType.fromString(reader.getString());
                    continue;
                }
                if ("verificationType".equals(fieldName)) {
                    verificationType = ImageVerificationType.fromString(reader.getString());
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    capabilities = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("batchSupportEndOfLife".equals(fieldName)) {
                    batchSupportEndOfLife = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            BatchSupportedImage deserializedBatchSupportedImage = new BatchSupportedImage(nodeAgentSkuId, imageReference, osType, verificationType);
            deserializedBatchSupportedImage.capabilities = capabilities;
            deserializedBatchSupportedImage.batchSupportEndOfLife = batchSupportEndOfLife;
            return deserializedBatchSupportedImage;
        });
    }
}

