/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchTaskContainerSettings;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.ResourceFile;
import com.azure.compute.batch.models.UserIdentity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchStartTask
implements JsonSerializable<BatchStartTask> {
    private final String commandLine;
    private BatchTaskContainerSettings containerSettings;
    private List<ResourceFile> resourceFiles;
    private List<EnvironmentSetting> environmentSettings;
    private UserIdentity userIdentity;
    private Integer maxTaskRetryCount;
    private Boolean waitForSuccess;

    public BatchStartTask(String commandLine) {
        this.commandLine = commandLine;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public BatchTaskContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public BatchStartTask setContainerSettings(BatchTaskContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    public List<ResourceFile> getResourceFiles() {
        return this.resourceFiles;
    }

    public BatchStartTask setResourceFiles(List<ResourceFile> resourceFiles) {
        this.resourceFiles = resourceFiles;
        return this;
    }

    public List<EnvironmentSetting> getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public BatchStartTask setEnvironmentSettings(List<EnvironmentSetting> environmentSettings) {
        this.environmentSettings = environmentSettings;
        return this;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public BatchStartTask setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
        return this;
    }

    public Integer getMaxTaskRetryCount() {
        return this.maxTaskRetryCount;
    }

    public BatchStartTask setMaxTaskRetryCount(Integer maxTaskRetryCount) {
        this.maxTaskRetryCount = maxTaskRetryCount;
        return this;
    }

    public Boolean isWaitForSuccess() {
        return this.waitForSuccess;
    }

    public BatchStartTask setWaitForSuccess(Boolean waitForSuccess) {
        this.waitForSuccess = waitForSuccess;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandLine", this.commandLine);
        jsonWriter.writeJsonField("containerSettings", (JsonSerializable)this.containerSettings);
        jsonWriter.writeArrayField("resourceFiles", this.resourceFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("environmentSettings", this.environmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("userIdentity", (JsonSerializable)this.userIdentity);
        jsonWriter.writeNumberField("maxTaskRetryCount", (Number)this.maxTaskRetryCount);
        jsonWriter.writeBooleanField("waitForSuccess", this.waitForSuccess);
        return jsonWriter.writeEndObject();
    }

    public static BatchStartTask fromJson(JsonReader jsonReader) throws IOException {
        return (BatchStartTask)jsonReader.readObject(reader -> {
            String commandLine = null;
            BatchTaskContainerSettings containerSettings = null;
            List resourceFiles = null;
            List environmentSettings = null;
            UserIdentity userIdentity = null;
            Integer maxTaskRetryCount = null;
            Boolean waitForSuccess = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commandLine".equals(fieldName)) {
                    commandLine = reader.getString();
                    continue;
                }
                if ("containerSettings".equals(fieldName)) {
                    containerSettings = BatchTaskContainerSettings.fromJson(reader);
                    continue;
                }
                if ("resourceFiles".equals(fieldName)) {
                    resourceFiles = reader.readArray(reader1 -> ResourceFile.fromJson(reader1));
                    continue;
                }
                if ("environmentSettings".equals(fieldName)) {
                    environmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("userIdentity".equals(fieldName)) {
                    userIdentity = UserIdentity.fromJson(reader);
                    continue;
                }
                if ("maxTaskRetryCount".equals(fieldName)) {
                    maxTaskRetryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("waitForSuccess".equals(fieldName)) {
                    waitForSuccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            BatchStartTask deserializedBatchStartTask = new BatchStartTask(commandLine);
            deserializedBatchStartTask.containerSettings = containerSettings;
            deserializedBatchStartTask.resourceFiles = resourceFiles;
            deserializedBatchStartTask.environmentSettings = environmentSettings;
            deserializedBatchStartTask.userIdentity = userIdentity;
            deserializedBatchStartTask.maxTaskRetryCount = maxTaskRetryCount;
            deserializedBatchStartTask.waitForSuccess = waitForSuccess;
            return deserializedBatchStartTask;
        });
    }
}

