/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchPoolUsageStatistics
implements JsonSerializable<BatchPoolUsageStatistics> {
    private final OffsetDateTime startTime;
    private final OffsetDateTime lastUpdateTime;
    private final Duration dedicatedCoreTime;

    private BatchPoolUsageStatistics(OffsetDateTime startTime, OffsetDateTime lastUpdateTime, Duration dedicatedCoreTime) {
        this.startTime = startTime;
        this.lastUpdateTime = lastUpdateTime;
        this.dedicatedCoreTime = dedicatedCoreTime;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Duration getDedicatedCoreTime() {
        return this.dedicatedCoreTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("lastUpdateTime", this.lastUpdateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdateTime));
        jsonWriter.writeStringField("dedicatedCoreTime", CoreUtils.durationToStringWithDays((Duration)this.dedicatedCoreTime));
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolUsageStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolUsageStatistics)jsonReader.readObject(reader -> {
            OffsetDateTime startTime = null;
            OffsetDateTime lastUpdateTime = null;
            Duration dedicatedCoreTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    lastUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dedicatedCoreTime".equals(fieldName)) {
                    dedicatedCoreTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchPoolUsageStatistics(startTime, lastUpdateTime, dedicatedCoreTime);
        });
    }
}

