/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchPoolUsageMetrics
implements JsonSerializable<BatchPoolUsageMetrics> {
    private final String poolId;
    private final OffsetDateTime startTime;
    private final OffsetDateTime endTime;
    private final String vmSize;
    private final double totalCoreHours;

    private BatchPoolUsageMetrics(String poolId, OffsetDateTime startTime, OffsetDateTime endTime, String vmSize, double totalCoreHours) {
        this.poolId = poolId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.vmSize = vmSize;
        this.totalCoreHours = totalCoreHours;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public String getVmSize() {
        return this.vmSize;
    }

    public double getTotalCoreHours() {
        return this.totalCoreHours;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("poolId", this.poolId);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeDoubleField("totalCoreHours", this.totalCoreHours);
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolUsageMetrics fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolUsageMetrics)jsonReader.readObject(reader -> {
            String poolId = null;
            OffsetDateTime startTime = null;
            OffsetDateTime endTime = null;
            String vmSize = null;
            double totalCoreHours = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("poolId".equals(fieldName)) {
                    poolId = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    vmSize = reader.getString();
                    continue;
                }
                if ("totalCoreHours".equals(fieldName)) {
                    totalCoreHours = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchPoolUsageMetrics(poolId, startTime, endTime, vmSize, totalCoreHours);
        });
    }
}

