/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchApplicationPackageReference;
import com.azure.compute.batch.models.BatchCertificateReference;
import com.azure.compute.batch.models.BatchNodeCommunicationMode;
import com.azure.compute.batch.models.BatchStartTask;
import com.azure.compute.batch.models.BatchTaskSchedulingPolicy;
import com.azure.compute.batch.models.MetadataItem;
import com.azure.compute.batch.models.MountConfiguration;
import com.azure.compute.batch.models.NetworkConfiguration;
import com.azure.compute.batch.models.UpgradePolicy;
import com.azure.compute.batch.models.UserAccount;
import com.azure.compute.batch.models.VirtualMachineConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BatchPoolUpdateContent
implements JsonSerializable<BatchPoolUpdateContent> {
    private String displayName;
    private String vmSize;
    private Boolean enableInterNodeCommunication;
    private BatchStartTask startTask;
    private List<BatchCertificateReference> certificateReferences;
    private List<BatchApplicationPackageReference> applicationPackageReferences;
    private List<MetadataItem> metadata;
    private VirtualMachineConfiguration virtualMachineConfiguration;
    private BatchNodeCommunicationMode targetNodeCommunicationMode;
    private Integer taskSlotsPerNode;
    private BatchTaskSchedulingPolicy taskSchedulingPolicy;
    private NetworkConfiguration networkConfiguration;
    private Map<String, String> resourceTags;
    private List<UserAccount> userAccounts;
    private List<MountConfiguration> mountConfiguration;
    private UpgradePolicy upgradePolicy;

    public String getDisplayName() {
        return this.displayName;
    }

    public BatchPoolUpdateContent setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getVmSize() {
        return this.vmSize;
    }

    public BatchPoolUpdateContent setVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public Boolean isEnableInterNodeCommunication() {
        return this.enableInterNodeCommunication;
    }

    public BatchPoolUpdateContent setEnableInterNodeCommunication(Boolean enableInterNodeCommunication) {
        this.enableInterNodeCommunication = enableInterNodeCommunication;
        return this;
    }

    public BatchStartTask getStartTask() {
        return this.startTask;
    }

    public BatchPoolUpdateContent setStartTask(BatchStartTask startTask) {
        this.startTask = startTask;
        return this;
    }

    public List<BatchCertificateReference> getCertificateReferences() {
        return this.certificateReferences;
    }

    public BatchPoolUpdateContent setCertificateReferences(List<BatchCertificateReference> certificateReferences) {
        this.certificateReferences = certificateReferences;
        return this;
    }

    public List<BatchApplicationPackageReference> getApplicationPackageReferences() {
        return this.applicationPackageReferences;
    }

    public BatchPoolUpdateContent setApplicationPackageReferences(List<BatchApplicationPackageReference> applicationPackageReferences) {
        this.applicationPackageReferences = applicationPackageReferences;
        return this;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchPoolUpdateContent setMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public VirtualMachineConfiguration getVirtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    public BatchPoolUpdateContent setVirtualMachineConfiguration(VirtualMachineConfiguration virtualMachineConfiguration) {
        this.virtualMachineConfiguration = virtualMachineConfiguration;
        return this;
    }

    public BatchNodeCommunicationMode getTargetNodeCommunicationMode() {
        return this.targetNodeCommunicationMode;
    }

    public BatchPoolUpdateContent setTargetNodeCommunicationMode(BatchNodeCommunicationMode targetNodeCommunicationMode) {
        this.targetNodeCommunicationMode = targetNodeCommunicationMode;
        return this;
    }

    public Integer getTaskSlotsPerNode() {
        return this.taskSlotsPerNode;
    }

    public BatchPoolUpdateContent setTaskSlotsPerNode(Integer taskSlotsPerNode) {
        this.taskSlotsPerNode = taskSlotsPerNode;
        return this;
    }

    public BatchTaskSchedulingPolicy getTaskSchedulingPolicy() {
        return this.taskSchedulingPolicy;
    }

    public BatchPoolUpdateContent setTaskSchedulingPolicy(BatchTaskSchedulingPolicy taskSchedulingPolicy) {
        this.taskSchedulingPolicy = taskSchedulingPolicy;
        return this;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public BatchPoolUpdateContent setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public Map<String, String> getResourceTags() {
        return this.resourceTags;
    }

    public BatchPoolUpdateContent setResourceTags(Map<String, String> resourceTags) {
        this.resourceTags = resourceTags;
        return this;
    }

    public List<UserAccount> getUserAccounts() {
        return this.userAccounts;
    }

    public BatchPoolUpdateContent setUserAccounts(List<UserAccount> userAccounts) {
        this.userAccounts = userAccounts;
        return this;
    }

    public List<MountConfiguration> getMountConfiguration() {
        return this.mountConfiguration;
    }

    public BatchPoolUpdateContent setMountConfiguration(List<MountConfiguration> mountConfiguration) {
        this.mountConfiguration = mountConfiguration;
        return this;
    }

    public UpgradePolicy getUpgradePolicy() {
        return this.upgradePolicy;
    }

    public BatchPoolUpdateContent setUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeBooleanField("enableInterNodeCommunication", this.enableInterNodeCommunication);
        jsonWriter.writeJsonField("startTask", (JsonSerializable)this.startTask);
        jsonWriter.writeArrayField("certificateReferences", this.certificateReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applicationPackageReferences", this.applicationPackageReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("virtualMachineConfiguration", (JsonSerializable)this.virtualMachineConfiguration);
        jsonWriter.writeStringField("targetNodeCommunicationMode", this.targetNodeCommunicationMode == null ? null : this.targetNodeCommunicationMode.toString());
        jsonWriter.writeNumberField("taskSlotsPerNode", (Number)this.taskSlotsPerNode);
        jsonWriter.writeJsonField("taskSchedulingPolicy", (JsonSerializable)this.taskSchedulingPolicy);
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeMapField("resourceTags", this.resourceTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("userAccounts", this.userAccounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("mountConfiguration", this.mountConfiguration, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("upgradePolicy", (JsonSerializable)this.upgradePolicy);
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolUpdateContent fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolUpdateContent)jsonReader.readObject(reader -> {
            BatchPoolUpdateContent deserializedBatchPoolUpdateContent = new BatchPoolUpdateContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.displayName = reader.getString();
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.vmSize = reader.getString();
                    continue;
                }
                if ("enableInterNodeCommunication".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.enableInterNodeCommunication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("startTask".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.startTask = BatchStartTask.fromJson(reader);
                    continue;
                }
                if ("certificateReferences".equals(fieldName)) {
                    List certificateReferences;
                    deserializedBatchPoolUpdateContent.certificateReferences = certificateReferences = reader.readArray(reader1 -> BatchCertificateReference.fromJson(reader1));
                    continue;
                }
                if ("applicationPackageReferences".equals(fieldName)) {
                    List applicationPackageReferences;
                    deserializedBatchPoolUpdateContent.applicationPackageReferences = applicationPackageReferences = reader.readArray(reader1 -> BatchApplicationPackageReference.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedBatchPoolUpdateContent.metadata = metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if ("virtualMachineConfiguration".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.virtualMachineConfiguration = VirtualMachineConfiguration.fromJson(reader);
                    continue;
                }
                if ("targetNodeCommunicationMode".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.targetNodeCommunicationMode = BatchNodeCommunicationMode.fromString(reader.getString());
                    continue;
                }
                if ("taskSlotsPerNode".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.taskSlotsPerNode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("taskSchedulingPolicy".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.taskSchedulingPolicy = BatchTaskSchedulingPolicy.fromJson(reader);
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.networkConfiguration = NetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("resourceTags".equals(fieldName)) {
                    Map resourceTags;
                    deserializedBatchPoolUpdateContent.resourceTags = resourceTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("userAccounts".equals(fieldName)) {
                    List userAccounts;
                    deserializedBatchPoolUpdateContent.userAccounts = userAccounts = reader.readArray(reader1 -> UserAccount.fromJson(reader1));
                    continue;
                }
                if ("mountConfiguration".equals(fieldName)) {
                    List mountConfiguration;
                    deserializedBatchPoolUpdateContent.mountConfiguration = mountConfiguration = reader.readArray(reader1 -> MountConfiguration.fromJson(reader1));
                    continue;
                }
                if ("upgradePolicy".equals(fieldName)) {
                    deserializedBatchPoolUpdateContent.upgradePolicy = UpgradePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchPoolUpdateContent;
        });
    }
}

