/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class BatchPoolEnableAutoScaleContent
implements JsonSerializable<BatchPoolEnableAutoScaleContent> {
    private String autoScaleFormula;
    private Duration autoScaleEvaluationInterval;

    public String getAutoScaleFormula() {
        return this.autoScaleFormula;
    }

    public BatchPoolEnableAutoScaleContent setAutoScaleFormula(String autoScaleFormula) {
        this.autoScaleFormula = autoScaleFormula;
        return this;
    }

    public Duration getAutoScaleEvaluationInterval() {
        return this.autoScaleEvaluationInterval;
    }

    public BatchPoolEnableAutoScaleContent setAutoScaleEvaluationInterval(Duration autoScaleEvaluationInterval) {
        this.autoScaleEvaluationInterval = autoScaleEvaluationInterval;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoScaleFormula", this.autoScaleFormula);
        jsonWriter.writeStringField("autoScaleEvaluationInterval", CoreUtils.durationToStringWithDays((Duration)this.autoScaleEvaluationInterval));
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolEnableAutoScaleContent fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolEnableAutoScaleContent)jsonReader.readObject(reader -> {
            BatchPoolEnableAutoScaleContent deserializedBatchPoolEnableAutoScaleContent = new BatchPoolEnableAutoScaleContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoScaleFormula".equals(fieldName)) {
                    deserializedBatchPoolEnableAutoScaleContent.autoScaleFormula = reader.getString();
                    continue;
                }
                if ("autoScaleEvaluationInterval".equals(fieldName)) {
                    deserializedBatchPoolEnableAutoScaleContent.autoScaleEvaluationInterval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchPoolEnableAutoScaleContent;
        });
    }
}

