/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeDeallocationOption;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class BatchNodeRemoveContent
implements JsonSerializable<BatchNodeRemoveContent> {
    private final List<String> nodeList;
    private Duration resizeTimeout;
    private BatchNodeDeallocationOption nodeDeallocationOption;

    public BatchNodeRemoveContent(List<String> nodeList) {
        this.nodeList = nodeList;
    }

    public List<String> getNodeList() {
        return this.nodeList;
    }

    public Duration getResizeTimeout() {
        return this.resizeTimeout;
    }

    public BatchNodeRemoveContent setResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    public BatchNodeDeallocationOption getNodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    public BatchNodeRemoveContent setNodeDeallocationOption(BatchNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("nodeList", this.nodeList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("resizeTimeout", CoreUtils.durationToStringWithDays((Duration)this.resizeTimeout));
        jsonWriter.writeStringField("nodeDeallocationOption", this.nodeDeallocationOption == null ? null : this.nodeDeallocationOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchNodeRemoveContent fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNodeRemoveContent)jsonReader.readObject(reader -> {
            List nodeList = null;
            Duration resizeTimeout = null;
            BatchNodeDeallocationOption nodeDeallocationOption = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nodeList".equals(fieldName)) {
                    nodeList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("resizeTimeout".equals(fieldName)) {
                    resizeTimeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("nodeDeallocationOption".equals(fieldName)) {
                    nodeDeallocationOption = BatchNodeDeallocationOption.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            BatchNodeRemoveContent deserializedBatchNodeRemoveContent = new BatchNodeRemoveContent(nodeList);
            deserializedBatchNodeRemoveContent.resizeTimeout = resizeTimeout;
            deserializedBatchNodeRemoveContent.nodeDeallocationOption = nodeDeallocationOption;
            return deserializedBatchNodeRemoveContent;
        });
    }
}

