/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.FileProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchNodeFile
implements JsonSerializable<BatchNodeFile> {
    private String name;
    private String url;
    private Boolean isDirectory;
    private FileProperties properties;

    private BatchNodeFile() {
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean isDirectory() {
        return this.isDirectory;
    }

    public FileProperties getProperties() {
        return this.properties;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeBooleanField("isDirectory", this.isDirectory);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static BatchNodeFile fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNodeFile)jsonReader.readObject(reader -> {
            BatchNodeFile deserializedBatchNodeFile = new BatchNodeFile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedBatchNodeFile.name = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedBatchNodeFile.url = reader.getString();
                    continue;
                }
                if ("isDirectory".equals(fieldName)) {
                    deserializedBatchNodeFile.isDirectory = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBatchNodeFile.properties = FileProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchNodeFile;
        });
    }
}

