/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchNodeAgentInfo
implements JsonSerializable<BatchNodeAgentInfo> {
    private final String version;
    private final OffsetDateTime lastUpdateTime;

    private BatchNodeAgentInfo(String version, OffsetDateTime lastUpdateTime) {
        this.version = version;
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getVersion() {
        return this.version;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("lastUpdateTime", this.lastUpdateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdateTime));
        return jsonWriter.writeEndObject();
    }

    public static BatchNodeAgentInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BatchNodeAgentInfo)jsonReader.readObject(reader -> {
            String version = null;
            OffsetDateTime lastUpdateTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    version = reader.getString();
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    lastUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchNodeAgentInfo(version, lastUpdateTime);
        });
    }
}

