/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.RecentBatchJob;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchJobScheduleExecutionInfo
implements JsonSerializable<BatchJobScheduleExecutionInfo> {
    private OffsetDateTime nextRunTime;
    private RecentBatchJob recentJob;
    private OffsetDateTime endTime;

    private BatchJobScheduleExecutionInfo() {
    }

    public OffsetDateTime getNextRunTime() {
        return this.nextRunTime;
    }

    public RecentBatchJob getRecentJob() {
        return this.recentJob;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextRunTime", this.nextRunTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextRunTime));
        jsonWriter.writeJsonField("recentJob", (JsonSerializable)this.recentJob);
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobScheduleExecutionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobScheduleExecutionInfo)jsonReader.readObject(reader -> {
            BatchJobScheduleExecutionInfo deserializedBatchJobScheduleExecutionInfo = new BatchJobScheduleExecutionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextRunTime".equals(fieldName)) {
                    deserializedBatchJobScheduleExecutionInfo.nextRunTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recentJob".equals(fieldName)) {
                    deserializedBatchJobScheduleExecutionInfo.recentJob = RecentBatchJob.fromJson(reader);
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedBatchJobScheduleExecutionInfo.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchJobScheduleExecutionInfo;
        });
    }
}

