/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobScheduleConfiguration;
import com.azure.compute.batch.models.BatchJobSpecification;
import com.azure.compute.batch.models.MetadataItem;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobScheduleCreateContent
implements JsonSerializable<BatchJobScheduleCreateContent> {
    private final String id;
    private String displayName;
    private final BatchJobScheduleConfiguration schedule;
    private final BatchJobSpecification jobSpecification;
    private List<MetadataItem> metadata;

    public BatchJobScheduleCreateContent(String id, BatchJobScheduleConfiguration schedule, BatchJobSpecification jobSpecification) {
        this.id = id;
        this.schedule = schedule;
        this.jobSpecification = jobSpecification;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BatchJobScheduleCreateContent setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public BatchJobScheduleConfiguration getSchedule() {
        return this.schedule;
    }

    public BatchJobSpecification getJobSpecification() {
        return this.jobSpecification;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJobScheduleCreateContent setMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeJsonField("jobSpecification", (JsonSerializable)this.jobSpecification);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobScheduleCreateContent fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobScheduleCreateContent)jsonReader.readObject(reader -> {
            String id = null;
            BatchJobScheduleConfiguration schedule = null;
            BatchJobSpecification jobSpecification = null;
            String displayName = null;
            List metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    schedule = BatchJobScheduleConfiguration.fromJson(reader);
                    continue;
                }
                if ("jobSpecification".equals(fieldName)) {
                    jobSpecification = BatchJobSpecification.fromJson(reader);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobScheduleCreateContent deserializedBatchJobScheduleCreateContent = new BatchJobScheduleCreateContent(id, schedule, jobSpecification);
            deserializedBatchJobScheduleCreateContent.displayName = displayName;
            deserializedBatchJobScheduleCreateContent.metadata = metadata;
            return deserializedBatchJobScheduleCreateContent;
        });
    }
}

