/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobScheduleConfiguration;
import com.azure.compute.batch.models.BatchJobScheduleExecutionInfo;
import com.azure.compute.batch.models.BatchJobScheduleState;
import com.azure.compute.batch.models.BatchJobScheduleStatistics;
import com.azure.compute.batch.models.BatchJobSpecification;
import com.azure.compute.batch.models.MetadataItem;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class BatchJobSchedule
implements JsonSerializable<BatchJobSchedule> {
    private String id;
    private String displayName;
    private String url;
    private String eTag;
    private OffsetDateTime lastModified;
    private OffsetDateTime creationTime;
    private BatchJobScheduleState state;
    private OffsetDateTime stateTransitionTime;
    private BatchJobScheduleState previousState;
    private OffsetDateTime previousStateTransitionTime;
    private BatchJobScheduleConfiguration schedule;
    private final BatchJobSpecification jobSpecification;
    private BatchJobScheduleExecutionInfo executionInfo;
    private List<MetadataItem> metadata;
    private BatchJobScheduleStatistics stats;

    public BatchJobSchedule(BatchJobSpecification jobSpecification) {
        this.jobSpecification = jobSpecification;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public BatchJobScheduleState getState() {
        return this.state;
    }

    public OffsetDateTime getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public BatchJobScheduleState getPreviousState() {
        return this.previousState;
    }

    public OffsetDateTime getPreviousStateTransitionTime() {
        return this.previousStateTransitionTime;
    }

    public BatchJobScheduleConfiguration getSchedule() {
        return this.schedule;
    }

    public BatchJobSchedule setSchedule(BatchJobScheduleConfiguration schedule) {
        this.schedule = schedule;
        return this;
    }

    public BatchJobSpecification getJobSpecification() {
        return this.jobSpecification;
    }

    public BatchJobScheduleExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJobSchedule setMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BatchJobScheduleStatistics getStats() {
        return this.stats;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("jobSpecification", (JsonSerializable)this.jobSpecification);
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobSchedule)jsonReader.readObject(reader -> {
            BatchJobSpecification jobSpecification = null;
            String id = null;
            String displayName = null;
            String url = null;
            String eTag = null;
            OffsetDateTime lastModified = null;
            OffsetDateTime creationTime = null;
            BatchJobScheduleState state = null;
            OffsetDateTime stateTransitionTime = null;
            BatchJobScheduleState previousState = null;
            OffsetDateTime previousStateTransitionTime = null;
            BatchJobScheduleConfiguration schedule = null;
            BatchJobScheduleExecutionInfo executionInfo = null;
            List metadata = null;
            BatchJobScheduleStatistics stats = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobSpecification".equals(fieldName)) {
                    jobSpecification = BatchJobSpecification.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    state = BatchJobScheduleState.fromString(reader.getString());
                    continue;
                }
                if ("stateTransitionTime".equals(fieldName)) {
                    stateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("previousState".equals(fieldName)) {
                    previousState = BatchJobScheduleState.fromString(reader.getString());
                    continue;
                }
                if ("previousStateTransitionTime".equals(fieldName)) {
                    previousStateTransitionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    schedule = BatchJobScheduleConfiguration.fromJson(reader);
                    continue;
                }
                if ("executionInfo".equals(fieldName)) {
                    executionInfo = BatchJobScheduleExecutionInfo.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if ("stats".equals(fieldName)) {
                    stats = BatchJobScheduleStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobSchedule deserializedBatchJobSchedule = new BatchJobSchedule(jobSpecification);
            deserializedBatchJobSchedule.id = id;
            deserializedBatchJobSchedule.displayName = displayName;
            deserializedBatchJobSchedule.url = url;
            deserializedBatchJobSchedule.eTag = eTag;
            deserializedBatchJobSchedule.lastModified = lastModified;
            deserializedBatchJobSchedule.creationTime = creationTime;
            deserializedBatchJobSchedule.state = state;
            deserializedBatchJobSchedule.stateTransitionTime = stateTransitionTime;
            deserializedBatchJobSchedule.previousState = previousState;
            deserializedBatchJobSchedule.previousStateTransitionTime = previousStateTransitionTime;
            deserializedBatchJobSchedule.schedule = schedule;
            deserializedBatchJobSchedule.executionInfo = executionInfo;
            deserializedBatchJobSchedule.metadata = metadata;
            deserializedBatchJobSchedule.stats = stats;
            return deserializedBatchJobSchedule;
        });
    }
}

