/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobReleaseTaskState;
import com.azure.compute.batch.models.BatchTaskContainerExecutionInfo;
import com.azure.compute.batch.models.BatchTaskExecutionResult;
import com.azure.compute.batch.models.BatchTaskFailureInfo;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchJobReleaseTaskExecutionInfo
implements JsonSerializable<BatchJobReleaseTaskExecutionInfo> {
    private final OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private final BatchJobReleaseTaskState state;
    private String taskRootDirectory;
    private String taskRootDirectoryUrl;
    private Integer exitCode;
    private BatchTaskContainerExecutionInfo containerInfo;
    private BatchTaskFailureInfo failureInfo;
    private BatchTaskExecutionResult result;

    private BatchJobReleaseTaskExecutionInfo(OffsetDateTime startTime, BatchJobReleaseTaskState state) {
        this.startTime = startTime;
        this.state = state;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public BatchJobReleaseTaskState getState() {
        return this.state;
    }

    public String getTaskRootDirectory() {
        return this.taskRootDirectory;
    }

    public String getTaskRootDirectoryUrl() {
        return this.taskRootDirectoryUrl;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public BatchTaskContainerExecutionInfo getContainerInfo() {
        return this.containerInfo;
    }

    public BatchTaskFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    public BatchTaskExecutionResult getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("taskRootDirectory", this.taskRootDirectory);
        jsonWriter.writeStringField("taskRootDirectoryUrl", this.taskRootDirectoryUrl);
        jsonWriter.writeNumberField("exitCode", (Number)this.exitCode);
        jsonWriter.writeJsonField("containerInfo", (JsonSerializable)this.containerInfo);
        jsonWriter.writeJsonField("failureInfo", (JsonSerializable)this.failureInfo);
        jsonWriter.writeStringField("result", this.result == null ? null : this.result.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchJobReleaseTaskExecutionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobReleaseTaskExecutionInfo)jsonReader.readObject(reader -> {
            OffsetDateTime startTime = null;
            BatchJobReleaseTaskState state = null;
            OffsetDateTime endTime = null;
            String taskRootDirectory = null;
            String taskRootDirectoryUrl = null;
            Integer exitCode = null;
            BatchTaskContainerExecutionInfo containerInfo = null;
            BatchTaskFailureInfo failureInfo = null;
            BatchTaskExecutionResult result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    state = BatchJobReleaseTaskState.fromString(reader.getString());
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("taskRootDirectory".equals(fieldName)) {
                    taskRootDirectory = reader.getString();
                    continue;
                }
                if ("taskRootDirectoryUrl".equals(fieldName)) {
                    taskRootDirectoryUrl = reader.getString();
                    continue;
                }
                if ("exitCode".equals(fieldName)) {
                    exitCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("containerInfo".equals(fieldName)) {
                    containerInfo = BatchTaskContainerExecutionInfo.fromJson(reader);
                    continue;
                }
                if ("failureInfo".equals(fieldName)) {
                    failureInfo = BatchTaskFailureInfo.fromJson(reader);
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = BatchTaskExecutionResult.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobReleaseTaskExecutionInfo deserializedBatchJobReleaseTaskExecutionInfo = new BatchJobReleaseTaskExecutionInfo(startTime, state);
            deserializedBatchJobReleaseTaskExecutionInfo.endTime = endTime;
            deserializedBatchJobReleaseTaskExecutionInfo.taskRootDirectory = taskRootDirectory;
            deserializedBatchJobReleaseTaskExecutionInfo.taskRootDirectoryUrl = taskRootDirectoryUrl;
            deserializedBatchJobReleaseTaskExecutionInfo.exitCode = exitCode;
            deserializedBatchJobReleaseTaskExecutionInfo.containerInfo = containerInfo;
            deserializedBatchJobReleaseTaskExecutionInfo.failureInfo = failureInfo;
            deserializedBatchJobReleaseTaskExecutionInfo.result = result;
            return deserializedBatchJobReleaseTaskExecutionInfo;
        });
    }
}

