/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobPreparationTaskState;
import com.azure.compute.batch.models.BatchTaskContainerExecutionInfo;
import com.azure.compute.batch.models.BatchTaskExecutionResult;
import com.azure.compute.batch.models.BatchTaskFailureInfo;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchJobPreparationTaskExecutionInfo
implements JsonSerializable<BatchJobPreparationTaskExecutionInfo> {
    private final OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private final BatchJobPreparationTaskState state;
    private String taskRootDirectory;
    private String taskRootDirectoryUrl;
    private Integer exitCode;
    private BatchTaskContainerExecutionInfo containerInfo;
    private BatchTaskFailureInfo failureInfo;
    private final int retryCount;
    private OffsetDateTime lastRetryTime;
    private BatchTaskExecutionResult result;

    private BatchJobPreparationTaskExecutionInfo(OffsetDateTime startTime, BatchJobPreparationTaskState state, int retryCount) {
        this.startTime = startTime;
        this.state = state;
        this.retryCount = retryCount;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public BatchJobPreparationTaskState getState() {
        return this.state;
    }

    public String getTaskRootDirectory() {
        return this.taskRootDirectory;
    }

    public String getTaskRootDirectoryUrl() {
        return this.taskRootDirectoryUrl;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public BatchTaskContainerExecutionInfo getContainerInfo() {
        return this.containerInfo;
    }

    public BatchTaskFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public OffsetDateTime getLastRetryTime() {
        return this.lastRetryTime;
    }

    public BatchTaskExecutionResult getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeIntField("retryCount", this.retryCount);
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("taskRootDirectory", this.taskRootDirectory);
        jsonWriter.writeStringField("taskRootDirectoryUrl", this.taskRootDirectoryUrl);
        jsonWriter.writeNumberField("exitCode", (Number)this.exitCode);
        jsonWriter.writeJsonField("containerInfo", (JsonSerializable)this.containerInfo);
        jsonWriter.writeJsonField("failureInfo", (JsonSerializable)this.failureInfo);
        jsonWriter.writeStringField("lastRetryTime", this.lastRetryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastRetryTime));
        jsonWriter.writeStringField("result", this.result == null ? null : this.result.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchJobPreparationTaskExecutionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobPreparationTaskExecutionInfo)jsonReader.readObject(reader -> {
            OffsetDateTime startTime = null;
            BatchJobPreparationTaskState state = null;
            int retryCount = 0;
            OffsetDateTime endTime = null;
            String taskRootDirectory = null;
            String taskRootDirectoryUrl = null;
            Integer exitCode = null;
            BatchTaskContainerExecutionInfo containerInfo = null;
            BatchTaskFailureInfo failureInfo = null;
            OffsetDateTime lastRetryTime = null;
            BatchTaskExecutionResult result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    state = BatchJobPreparationTaskState.fromString(reader.getString());
                    continue;
                }
                if ("retryCount".equals(fieldName)) {
                    retryCount = reader.getInt();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("taskRootDirectory".equals(fieldName)) {
                    taskRootDirectory = reader.getString();
                    continue;
                }
                if ("taskRootDirectoryUrl".equals(fieldName)) {
                    taskRootDirectoryUrl = reader.getString();
                    continue;
                }
                if ("exitCode".equals(fieldName)) {
                    exitCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("containerInfo".equals(fieldName)) {
                    containerInfo = BatchTaskContainerExecutionInfo.fromJson(reader);
                    continue;
                }
                if ("failureInfo".equals(fieldName)) {
                    failureInfo = BatchTaskFailureInfo.fromJson(reader);
                    continue;
                }
                if ("lastRetryTime".equals(fieldName)) {
                    lastRetryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = BatchTaskExecutionResult.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobPreparationTaskExecutionInfo deserializedBatchJobPreparationTaskExecutionInfo = new BatchJobPreparationTaskExecutionInfo(startTime, state, retryCount);
            deserializedBatchJobPreparationTaskExecutionInfo.endTime = endTime;
            deserializedBatchJobPreparationTaskExecutionInfo.taskRootDirectory = taskRootDirectory;
            deserializedBatchJobPreparationTaskExecutionInfo.taskRootDirectoryUrl = taskRootDirectoryUrl;
            deserializedBatchJobPreparationTaskExecutionInfo.exitCode = exitCode;
            deserializedBatchJobPreparationTaskExecutionInfo.containerInfo = containerInfo;
            deserializedBatchJobPreparationTaskExecutionInfo.failureInfo = failureInfo;
            deserializedBatchJobPreparationTaskExecutionInfo.lastRetryTime = lastRetryTime;
            deserializedBatchJobPreparationTaskExecutionInfo.result = result;
            return deserializedBatchJobPreparationTaskExecutionInfo;
        });
    }
}

