/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.AuthenticationTokenSettings;
import com.azure.compute.batch.models.BatchApplicationPackageReference;
import com.azure.compute.batch.models.BatchTaskConstraints;
import com.azure.compute.batch.models.BatchTaskContainerSettings;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.OutputFile;
import com.azure.compute.batch.models.ResourceFile;
import com.azure.compute.batch.models.UserIdentity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobManagerTask
implements JsonSerializable<BatchJobManagerTask> {
    private final String id;
    private String displayName;
    private final String commandLine;
    private BatchTaskContainerSettings containerSettings;
    private List<ResourceFile> resourceFiles;
    private List<OutputFile> outputFiles;
    private List<EnvironmentSetting> environmentSettings;
    private BatchTaskConstraints constraints;
    private Integer requiredSlots;
    private Boolean killJobOnCompletion;
    private UserIdentity userIdentity;
    private Boolean runExclusive;
    private List<BatchApplicationPackageReference> applicationPackageReferences;
    private AuthenticationTokenSettings authenticationTokenSettings;
    private Boolean allowLowPriorityNode;

    public BatchJobManagerTask(String id, String commandLine) {
        this.id = id;
        this.commandLine = commandLine;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BatchJobManagerTask setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public BatchTaskContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public BatchJobManagerTask setContainerSettings(BatchTaskContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    public List<ResourceFile> getResourceFiles() {
        return this.resourceFiles;
    }

    public BatchJobManagerTask setResourceFiles(List<ResourceFile> resourceFiles) {
        this.resourceFiles = resourceFiles;
        return this;
    }

    public List<OutputFile> getOutputFiles() {
        return this.outputFiles;
    }

    public BatchJobManagerTask setOutputFiles(List<OutputFile> outputFiles) {
        this.outputFiles = outputFiles;
        return this;
    }

    public List<EnvironmentSetting> getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public BatchJobManagerTask setEnvironmentSettings(List<EnvironmentSetting> environmentSettings) {
        this.environmentSettings = environmentSettings;
        return this;
    }

    public BatchTaskConstraints getConstraints() {
        return this.constraints;
    }

    public BatchJobManagerTask setConstraints(BatchTaskConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public Integer getRequiredSlots() {
        return this.requiredSlots;
    }

    public BatchJobManagerTask setRequiredSlots(Integer requiredSlots) {
        this.requiredSlots = requiredSlots;
        return this;
    }

    public Boolean isKillJobOnCompletion() {
        return this.killJobOnCompletion;
    }

    public BatchJobManagerTask setKillJobOnCompletion(Boolean killJobOnCompletion) {
        this.killJobOnCompletion = killJobOnCompletion;
        return this;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public BatchJobManagerTask setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
        return this;
    }

    public Boolean isRunExclusive() {
        return this.runExclusive;
    }

    public BatchJobManagerTask setRunExclusive(Boolean runExclusive) {
        this.runExclusive = runExclusive;
        return this;
    }

    public List<BatchApplicationPackageReference> getApplicationPackageReferences() {
        return this.applicationPackageReferences;
    }

    public BatchJobManagerTask setApplicationPackageReferences(List<BatchApplicationPackageReference> applicationPackageReferences) {
        this.applicationPackageReferences = applicationPackageReferences;
        return this;
    }

    public AuthenticationTokenSettings getAuthenticationTokenSettings() {
        return this.authenticationTokenSettings;
    }

    public BatchJobManagerTask setAuthenticationTokenSettings(AuthenticationTokenSettings authenticationTokenSettings) {
        this.authenticationTokenSettings = authenticationTokenSettings;
        return this;
    }

    public Boolean isAllowLowPriorityNode() {
        return this.allowLowPriorityNode;
    }

    public BatchJobManagerTask setAllowLowPriorityNode(Boolean allowLowPriorityNode) {
        this.allowLowPriorityNode = allowLowPriorityNode;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("commandLine", this.commandLine);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("containerSettings", (JsonSerializable)this.containerSettings);
        jsonWriter.writeArrayField("resourceFiles", this.resourceFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputFiles", this.outputFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("environmentSettings", this.environmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeNumberField("requiredSlots", (Number)this.requiredSlots);
        jsonWriter.writeBooleanField("killJobOnCompletion", this.killJobOnCompletion);
        jsonWriter.writeJsonField("userIdentity", (JsonSerializable)this.userIdentity);
        jsonWriter.writeBooleanField("runExclusive", this.runExclusive);
        jsonWriter.writeArrayField("applicationPackageReferences", this.applicationPackageReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("authenticationTokenSettings", (JsonSerializable)this.authenticationTokenSettings);
        jsonWriter.writeBooleanField("allowLowPriorityNode", this.allowLowPriorityNode);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobManagerTask fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobManagerTask)jsonReader.readObject(reader -> {
            String id = null;
            String commandLine = null;
            String displayName = null;
            BatchTaskContainerSettings containerSettings = null;
            List resourceFiles = null;
            List outputFiles = null;
            List environmentSettings = null;
            BatchTaskConstraints constraints = null;
            Integer requiredSlots = null;
            Boolean killJobOnCompletion = null;
            UserIdentity userIdentity = null;
            Boolean runExclusive = null;
            List applicationPackageReferences = null;
            AuthenticationTokenSettings authenticationTokenSettings = null;
            Boolean allowLowPriorityNode = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("commandLine".equals(fieldName)) {
                    commandLine = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("containerSettings".equals(fieldName)) {
                    containerSettings = BatchTaskContainerSettings.fromJson(reader);
                    continue;
                }
                if ("resourceFiles".equals(fieldName)) {
                    resourceFiles = reader.readArray(reader1 -> ResourceFile.fromJson(reader1));
                    continue;
                }
                if ("outputFiles".equals(fieldName)) {
                    outputFiles = reader.readArray(reader1 -> OutputFile.fromJson(reader1));
                    continue;
                }
                if ("environmentSettings".equals(fieldName)) {
                    environmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    constraints = BatchTaskConstraints.fromJson(reader);
                    continue;
                }
                if ("requiredSlots".equals(fieldName)) {
                    requiredSlots = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("killJobOnCompletion".equals(fieldName)) {
                    killJobOnCompletion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("userIdentity".equals(fieldName)) {
                    userIdentity = UserIdentity.fromJson(reader);
                    continue;
                }
                if ("runExclusive".equals(fieldName)) {
                    runExclusive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("applicationPackageReferences".equals(fieldName)) {
                    applicationPackageReferences = reader.readArray(reader1 -> BatchApplicationPackageReference.fromJson(reader1));
                    continue;
                }
                if ("authenticationTokenSettings".equals(fieldName)) {
                    authenticationTokenSettings = AuthenticationTokenSettings.fromJson(reader);
                    continue;
                }
                if ("allowLowPriorityNode".equals(fieldName)) {
                    allowLowPriorityNode = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobManagerTask deserializedBatchJobManagerTask = new BatchJobManagerTask(id, commandLine);
            deserializedBatchJobManagerTask.displayName = displayName;
            deserializedBatchJobManagerTask.containerSettings = containerSettings;
            deserializedBatchJobManagerTask.resourceFiles = resourceFiles;
            deserializedBatchJobManagerTask.outputFiles = outputFiles;
            deserializedBatchJobManagerTask.environmentSettings = environmentSettings;
            deserializedBatchJobManagerTask.constraints = constraints;
            deserializedBatchJobManagerTask.requiredSlots = requiredSlots;
            deserializedBatchJobManagerTask.killJobOnCompletion = killJobOnCompletion;
            deserializedBatchJobManagerTask.userIdentity = userIdentity;
            deserializedBatchJobManagerTask.runExclusive = runExclusive;
            deserializedBatchJobManagerTask.applicationPackageReferences = applicationPackageReferences;
            deserializedBatchJobManagerTask.authenticationTokenSettings = authenticationTokenSettings;
            deserializedBatchJobManagerTask.allowLowPriorityNode = allowLowPriorityNode;
            return deserializedBatchJobManagerTask;
        });
    }
}

