/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobConstraints;
import com.azure.compute.batch.models.BatchJobManagerTask;
import com.azure.compute.batch.models.BatchJobNetworkConfiguration;
import com.azure.compute.batch.models.BatchJobPreparationTask;
import com.azure.compute.batch.models.BatchJobReleaseTask;
import com.azure.compute.batch.models.BatchPoolInfo;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.MetadataItem;
import com.azure.compute.batch.models.OnAllBatchTasksComplete;
import com.azure.compute.batch.models.OnBatchTaskFailure;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobCreateContent
implements JsonSerializable<BatchJobCreateContent> {
    private final String id;
    private String displayName;
    private Boolean usesTaskDependencies;
    private Integer priority;
    private Boolean allowTaskPreemption;
    private Integer maxParallelTasks;
    private BatchJobConstraints constraints;
    private BatchJobManagerTask jobManagerTask;
    private BatchJobPreparationTask jobPreparationTask;
    private BatchJobReleaseTask jobReleaseTask;
    private List<EnvironmentSetting> commonEnvironmentSettings;
    private final BatchPoolInfo poolInfo;
    private OnAllBatchTasksComplete onAllTasksComplete;
    private OnBatchTaskFailure onTaskFailure;
    private BatchJobNetworkConfiguration networkConfiguration;
    private List<MetadataItem> metadata;

    public BatchJobCreateContent(String id, BatchPoolInfo poolInfo) {
        this.id = id;
        this.poolInfo = poolInfo;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BatchJobCreateContent setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean isUsesTaskDependencies() {
        return this.usesTaskDependencies;
    }

    public BatchJobCreateContent setUsesTaskDependencies(Boolean usesTaskDependencies) {
        this.usesTaskDependencies = usesTaskDependencies;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public BatchJobCreateContent setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Boolean isAllowTaskPreemption() {
        return this.allowTaskPreemption;
    }

    public BatchJobCreateContent setAllowTaskPreemption(Boolean allowTaskPreemption) {
        this.allowTaskPreemption = allowTaskPreemption;
        return this;
    }

    public Integer getMaxParallelTasks() {
        return this.maxParallelTasks;
    }

    public BatchJobCreateContent setMaxParallelTasks(Integer maxParallelTasks) {
        this.maxParallelTasks = maxParallelTasks;
        return this;
    }

    public BatchJobConstraints getConstraints() {
        return this.constraints;
    }

    public BatchJobCreateContent setConstraints(BatchJobConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public BatchJobManagerTask getJobManagerTask() {
        return this.jobManagerTask;
    }

    public BatchJobCreateContent setJobManagerTask(BatchJobManagerTask jobManagerTask) {
        this.jobManagerTask = jobManagerTask;
        return this;
    }

    public BatchJobPreparationTask getJobPreparationTask() {
        return this.jobPreparationTask;
    }

    public BatchJobCreateContent setJobPreparationTask(BatchJobPreparationTask jobPreparationTask) {
        this.jobPreparationTask = jobPreparationTask;
        return this;
    }

    public BatchJobReleaseTask getJobReleaseTask() {
        return this.jobReleaseTask;
    }

    public BatchJobCreateContent setJobReleaseTask(BatchJobReleaseTask jobReleaseTask) {
        this.jobReleaseTask = jobReleaseTask;
        return this;
    }

    public List<EnvironmentSetting> getCommonEnvironmentSettings() {
        return this.commonEnvironmentSettings;
    }

    public BatchJobCreateContent setCommonEnvironmentSettings(List<EnvironmentSetting> commonEnvironmentSettings) {
        this.commonEnvironmentSettings = commonEnvironmentSettings;
        return this;
    }

    public BatchPoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public OnAllBatchTasksComplete getOnAllTasksComplete() {
        return this.onAllTasksComplete;
    }

    public BatchJobCreateContent setOnAllTasksComplete(OnAllBatchTasksComplete onAllTasksComplete) {
        this.onAllTasksComplete = onAllTasksComplete;
        return this;
    }

    public OnBatchTaskFailure getOnTaskFailure() {
        return this.onTaskFailure;
    }

    public BatchJobCreateContent setOnTaskFailure(OnBatchTaskFailure onTaskFailure) {
        this.onTaskFailure = onTaskFailure;
        return this;
    }

    public BatchJobNetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public BatchJobCreateContent setNetworkConfiguration(BatchJobNetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJobCreateContent setMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("poolInfo", (JsonSerializable)this.poolInfo);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("usesTaskDependencies", this.usesTaskDependencies);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeBooleanField("allowTaskPreemption", this.allowTaskPreemption);
        jsonWriter.writeNumberField("maxParallelTasks", (Number)this.maxParallelTasks);
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeJsonField("jobManagerTask", (JsonSerializable)this.jobManagerTask);
        jsonWriter.writeJsonField("jobPreparationTask", (JsonSerializable)this.jobPreparationTask);
        jsonWriter.writeJsonField("jobReleaseTask", (JsonSerializable)this.jobReleaseTask);
        jsonWriter.writeArrayField("commonEnvironmentSettings", this.commonEnvironmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("onAllTasksComplete", this.onAllTasksComplete == null ? null : this.onAllTasksComplete.toString());
        jsonWriter.writeStringField("onTaskFailure", this.onTaskFailure == null ? null : this.onTaskFailure.toString());
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobCreateContent fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobCreateContent)jsonReader.readObject(reader -> {
            String id = null;
            BatchPoolInfo poolInfo = null;
            String displayName = null;
            Boolean usesTaskDependencies = null;
            Integer priority = null;
            Boolean allowTaskPreemption = null;
            Integer maxParallelTasks = null;
            BatchJobConstraints constraints = null;
            BatchJobManagerTask jobManagerTask = null;
            BatchJobPreparationTask jobPreparationTask = null;
            BatchJobReleaseTask jobReleaseTask = null;
            List commonEnvironmentSettings = null;
            OnAllBatchTasksComplete onAllTasksComplete = null;
            OnBatchTaskFailure onTaskFailure = null;
            BatchJobNetworkConfiguration networkConfiguration = null;
            List metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("poolInfo".equals(fieldName)) {
                    poolInfo = BatchPoolInfo.fromJson(reader);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("usesTaskDependencies".equals(fieldName)) {
                    usesTaskDependencies = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowTaskPreemption".equals(fieldName)) {
                    allowTaskPreemption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxParallelTasks".equals(fieldName)) {
                    maxParallelTasks = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    constraints = BatchJobConstraints.fromJson(reader);
                    continue;
                }
                if ("jobManagerTask".equals(fieldName)) {
                    jobManagerTask = BatchJobManagerTask.fromJson(reader);
                    continue;
                }
                if ("jobPreparationTask".equals(fieldName)) {
                    jobPreparationTask = BatchJobPreparationTask.fromJson(reader);
                    continue;
                }
                if ("jobReleaseTask".equals(fieldName)) {
                    jobReleaseTask = BatchJobReleaseTask.fromJson(reader);
                    continue;
                }
                if ("commonEnvironmentSettings".equals(fieldName)) {
                    commonEnvironmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("onAllTasksComplete".equals(fieldName)) {
                    onAllTasksComplete = OnAllBatchTasksComplete.fromString(reader.getString());
                    continue;
                }
                if ("onTaskFailure".equals(fieldName)) {
                    onTaskFailure = OnBatchTaskFailure.fromString(reader.getString());
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    networkConfiguration = BatchJobNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobCreateContent deserializedBatchJobCreateContent = new BatchJobCreateContent(id, poolInfo);
            deserializedBatchJobCreateContent.displayName = displayName;
            deserializedBatchJobCreateContent.usesTaskDependencies = usesTaskDependencies;
            deserializedBatchJobCreateContent.priority = priority;
            deserializedBatchJobCreateContent.allowTaskPreemption = allowTaskPreemption;
            deserializedBatchJobCreateContent.maxParallelTasks = maxParallelTasks;
            deserializedBatchJobCreateContent.constraints = constraints;
            deserializedBatchJobCreateContent.jobManagerTask = jobManagerTask;
            deserializedBatchJobCreateContent.jobPreparationTask = jobPreparationTask;
            deserializedBatchJobCreateContent.jobReleaseTask = jobReleaseTask;
            deserializedBatchJobCreateContent.commonEnvironmentSettings = commonEnvironmentSettings;
            deserializedBatchJobCreateContent.onAllTasksComplete = onAllTasksComplete;
            deserializedBatchJobCreateContent.onTaskFailure = onTaskFailure;
            deserializedBatchJobCreateContent.networkConfiguration = networkConfiguration;
            deserializedBatchJobCreateContent.metadata = metadata;
            return deserializedBatchJobCreateContent;
        });
    }
}

