/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class BatchJobConstraints
implements JsonSerializable<BatchJobConstraints> {
    private Duration maxWallClockTime;
    private Integer maxTaskRetryCount;

    public Duration getMaxWallClockTime() {
        return this.maxWallClockTime;
    }

    public BatchJobConstraints setMaxWallClockTime(Duration maxWallClockTime) {
        this.maxWallClockTime = maxWallClockTime;
        return this;
    }

    public Integer getMaxTaskRetryCount() {
        return this.maxTaskRetryCount;
    }

    public BatchJobConstraints setMaxTaskRetryCount(Integer maxTaskRetryCount) {
        this.maxTaskRetryCount = maxTaskRetryCount;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("maxWallClockTime", CoreUtils.durationToStringWithDays((Duration)this.maxWallClockTime));
        jsonWriter.writeNumberField("maxTaskRetryCount", (Number)this.maxTaskRetryCount);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobConstraints fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobConstraints)jsonReader.readObject(reader -> {
            BatchJobConstraints deserializedBatchJobConstraints = new BatchJobConstraints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxWallClockTime".equals(fieldName)) {
                    deserializedBatchJobConstraints.maxWallClockTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxTaskRetryCount".equals(fieldName)) {
                    deserializedBatchJobConstraints.maxTaskRetryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchJobConstraints;
        });
    }
}

