/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchPoolLifetimeOption;
import com.azure.compute.batch.models.BatchPoolSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchAutoPoolSpecification
implements JsonSerializable<BatchAutoPoolSpecification> {
    private String autoPoolIdPrefix;
    private final BatchPoolLifetimeOption poolLifetimeOption;
    private Boolean keepAlive;
    private BatchPoolSpecification pool;

    public BatchAutoPoolSpecification(BatchPoolLifetimeOption poolLifetimeOption) {
        this.poolLifetimeOption = poolLifetimeOption;
    }

    public String getAutoPoolIdPrefix() {
        return this.autoPoolIdPrefix;
    }

    public BatchAutoPoolSpecification setAutoPoolIdPrefix(String autoPoolIdPrefix) {
        this.autoPoolIdPrefix = autoPoolIdPrefix;
        return this;
    }

    public BatchPoolLifetimeOption getPoolLifetimeOption() {
        return this.poolLifetimeOption;
    }

    public Boolean isKeepAlive() {
        return this.keepAlive;
    }

    public BatchAutoPoolSpecification setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public BatchPoolSpecification getPool() {
        return this.pool;
    }

    public BatchAutoPoolSpecification setPool(BatchPoolSpecification pool) {
        this.pool = pool;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("poolLifetimeOption", this.poolLifetimeOption == null ? null : this.poolLifetimeOption.toString());
        jsonWriter.writeStringField("autoPoolIdPrefix", this.autoPoolIdPrefix);
        jsonWriter.writeBooleanField("keepAlive", this.keepAlive);
        jsonWriter.writeJsonField("pool", (JsonSerializable)this.pool);
        return jsonWriter.writeEndObject();
    }

    public static BatchAutoPoolSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (BatchAutoPoolSpecification)jsonReader.readObject(reader -> {
            BatchPoolLifetimeOption poolLifetimeOption = null;
            String autoPoolIdPrefix = null;
            Boolean keepAlive = null;
            BatchPoolSpecification pool = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("poolLifetimeOption".equals(fieldName)) {
                    poolLifetimeOption = BatchPoolLifetimeOption.fromString(reader.getString());
                    continue;
                }
                if ("autoPoolIdPrefix".equals(fieldName)) {
                    autoPoolIdPrefix = reader.getString();
                    continue;
                }
                if ("keepAlive".equals(fieldName)) {
                    keepAlive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("pool".equals(fieldName)) {
                    pool = BatchPoolSpecification.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchAutoPoolSpecification deserializedBatchAutoPoolSpecification = new BatchAutoPoolSpecification(poolLifetimeOption);
            deserializedBatchAutoPoolSpecification.autoPoolIdPrefix = autoPoolIdPrefix;
            deserializedBatchAutoPoolSpecification.keepAlive = keepAlive;
            deserializedBatchAutoPoolSpecification.pool = pool;
            return deserializedBatchAutoPoolSpecification;
        });
    }
}

