/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.implementation;

import com.azure.compute.batch.BatchServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class BatchClientImpl {
    private final BatchClientService service;
    private final String endpoint;
    private final BatchServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public BatchServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public BatchClientImpl(String endpoint, BatchServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public BatchClientImpl(HttpPipeline httpPipeline, String endpoint, BatchServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public BatchClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, BatchServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (BatchClientService)RestProxy.create(BatchClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listApplicationsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listApplications(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listApplicationsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listApplicationsSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listApplicationsNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listApplicationsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listApplicationsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listApplications(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listApplicationsSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listApplicationsNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getApplicationWithResponseAsync(String applicationId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getApplication(this.getEndpoint(), this.getServiceVersion().getVersion(), applicationId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getApplicationWithResponse(String applicationId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getApplicationSync(this.getEndpoint(), this.getServiceVersion().getVersion(), applicationId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listPoolUsageMetricsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPoolUsageMetrics(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPoolUsageMetricsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolUsageMetricsSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolUsageMetricsNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listPoolUsageMetricsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listPoolUsageMetricsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPoolUsageMetrics(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolUsageMetricsSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolUsageMetricsNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createPoolWithResponseAsync(BinaryData pool, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createPool(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", "application/json", pool, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createPoolWithResponse(BinaryData pool, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.createPoolSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", "application/json", pool, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listPoolsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPools(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPoolsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolsSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolsNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listPoolsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listPoolsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPools(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolsSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolsNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePoolWithResponseAsync(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePool(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePoolWithResponse(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deletePoolSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> poolExistsWithResponseAsync(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.poolExists(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> poolExistsWithResponse(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.poolExistsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getPoolWithResponseAsync(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPool(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getPoolWithResponse(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getPoolSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updatePoolWithResponseAsync(String poolId, BinaryData pool, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updatePool(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", pool, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updatePoolWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.updatePoolSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", pool, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disablePoolAutoScaleWithResponseAsync(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disablePoolAutoScale(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disablePoolAutoScaleWithResponse(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.disablePoolAutoScaleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enablePoolAutoScaleWithResponseAsync(String poolId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enablePoolAutoScale(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", content, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enablePoolAutoScaleWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.enablePoolAutoScaleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", content, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> evaluatePoolAutoScaleWithResponseAsync(String poolId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.evaluatePoolAutoScale(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", content, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> evaluatePoolAutoScaleWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.evaluatePoolAutoScaleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", content, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resizePoolWithResponseAsync(String poolId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resizePool(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", content, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resizePoolWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.resizePoolSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", content, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopPoolResizeWithResponseAsync(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stopPoolResize(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopPoolResizeWithResponse(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.stopPoolResizeSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replacePoolPropertiesWithResponseAsync(String poolId, BinaryData pool, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replacePoolProperties(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", pool, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replacePoolPropertiesWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.replacePoolPropertiesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", pool, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeNodesWithResponseAsync(String poolId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeNodes(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", content, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeNodesWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.removeNodesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, "application/json", content, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listSupportedImagesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSupportedImages(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listSupportedImagesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listSupportedImagesSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listSupportedImagesNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listSupportedImagesSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listSupportedImagesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listSupportedImages(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listSupportedImagesSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listSupportedImagesNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listPoolNodeCountsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPoolNodeCounts(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPoolNodeCountsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolNodeCountsSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolNodeCountsNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listPoolNodeCountsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listPoolNodeCountsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPoolNodeCounts(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolNodeCountsSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listPoolNodeCountsNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteJobWithResponseAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteJob(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteJobWithResponse(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteJobSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobWithResponseAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getJob(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobWithResponse(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getJobSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateJobWithResponseAsync(String jobId, BinaryData job, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateJob(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", job, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.updateJobSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", job, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceJobWithResponseAsync(String jobId, BinaryData job, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replaceJob(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", job, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.replaceJobSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", job, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disableJobWithResponseAsync(String jobId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableJob(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", content, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disableJobWithResponse(String jobId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.disableJobSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", content, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableJobWithResponseAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enableJob(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableJobWithResponse(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.enableJobSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateJobWithResponseAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return FluxUtil.withContext(context -> this.service.terminateJob(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateJobWithResponse(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return this.service.terminateJobSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createJobWithResponseAsync(BinaryData job, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createJob(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", "application/json", job, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createJobWithResponse(BinaryData job, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.createJobSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", "application/json", job, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listJobsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobs(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobsSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobsNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listJobsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listJobsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobs(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobsSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobsNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listJobsFromScheduleSinglePageAsync(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobsFromSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobsFromScheduleAsync(String jobScheduleId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobsFromScheduleSinglePageAsync(jobScheduleId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobsFromScheduleNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listJobsFromScheduleSinglePage(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listJobsFromScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobsFromSchedule(String jobScheduleId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobsFromScheduleSinglePage(jobScheduleId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobsFromScheduleNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listJobPreparationAndReleaseTaskStatusSinglePageAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobPreparationAndReleaseTaskStatus(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobPreparationAndReleaseTaskStatusAsync(String jobId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobPreparationAndReleaseTaskStatusSinglePageAsync(jobId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobPreparationAndReleaseTaskStatusNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listJobPreparationAndReleaseTaskStatusSinglePage(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listJobPreparationAndReleaseTaskStatusSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobPreparationAndReleaseTaskStatus(String jobId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobPreparationAndReleaseTaskStatusSinglePage(jobId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobPreparationAndReleaseTaskStatusNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobTaskCountsWithResponseAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getJobTaskCounts(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobTaskCountsWithResponse(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getJobTaskCountsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createCertificateWithResponseAsync(BinaryData certificate, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createCertificate(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", "application/json", certificate, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createCertificateWithResponse(BinaryData certificate, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.createCertificateSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", "application/json", certificate, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listCertificatesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCertificates(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listCertificatesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listCertificatesSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listCertificatesNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listCertificatesSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listCertificatesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listCertificates(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listCertificatesSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listCertificatesNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelCertificateDeletionWithResponseAsync(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelCertificateDeletion(this.getEndpoint(), this.getServiceVersion().getVersion(), thumbprintAlgorithm, thumbprint, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelCertificateDeletionWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.cancelCertificateDeletionSync(this.getEndpoint(), this.getServiceVersion().getVersion(), thumbprintAlgorithm, thumbprint, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCertificateWithResponseAsync(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificate(this.getEndpoint(), this.getServiceVersion().getVersion(), thumbprintAlgorithm, thumbprint, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteCertificateSync(this.getEndpoint(), this.getServiceVersion().getVersion(), thumbprintAlgorithm, thumbprint, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateWithResponseAsync(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificate(this.getEndpoint(), this.getServiceVersion().getVersion(), thumbprintAlgorithm, thumbprint, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getCertificateSync(this.getEndpoint(), this.getServiceVersion().getVersion(), thumbprintAlgorithm, thumbprint, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> jobScheduleExistsWithResponseAsync(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.jobScheduleExists(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> jobScheduleExistsWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.jobScheduleExistsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteJobScheduleWithResponseAsync(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteJobSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteJobScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobScheduleWithResponseAsync(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getJobSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getJobScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateJobScheduleWithResponseAsync(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateJobSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobScheduleId, "application/json", jobSchedule, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.updateJobScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobScheduleId, "application/json", jobSchedule, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceJobScheduleWithResponseAsync(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replaceJobSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobScheduleId, "application/json", jobSchedule, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.replaceJobScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobScheduleId, "application/json", jobSchedule, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disableJobScheduleWithResponseAsync(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableJobSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.disableJobScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableJobScheduleWithResponseAsync(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enableJobSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.enableJobScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateJobScheduleWithResponseAsync(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.terminateJobSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.terminateJobScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobScheduleId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createJobScheduleWithResponseAsync(BinaryData jobSchedule, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createJobSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", "application/json", jobSchedule, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createJobScheduleWithResponse(BinaryData jobSchedule, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.createJobScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", "application/json", jobSchedule, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listJobSchedulesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobSchedules(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobSchedulesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobSchedulesSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobSchedulesNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listJobSchedulesSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listJobSchedulesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobSchedules(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobSchedulesSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listJobSchedulesNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createTaskWithResponseAsync(String jobId, BinaryData task, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createTask(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", task, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createTaskWithResponse(String jobId, BinaryData task, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.createTaskSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", task, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listTasksSinglePageAsync(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listTasks(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTasksAsync(String jobId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listTasksSinglePageAsync(jobId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listTasksNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listTasksSinglePage(String jobId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listTasksSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTasks(String jobId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listTasksSinglePage(jobId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listTasksNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createTaskCollectionWithResponseAsync(String jobId, BinaryData taskCollection, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createTaskCollection(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", taskCollection, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createTaskCollectionWithResponse(String jobId, BinaryData taskCollection, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.createTaskCollectionSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, "application/json", taskCollection, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTaskWithResponseAsync(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteTask(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteTaskSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTaskWithResponseAsync(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTask(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getTaskSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceTaskWithResponseAsync(String jobId, String taskId, BinaryData task, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replaceTask(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, taskId, "application/json", task, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceTaskWithResponse(String jobId, String taskId, BinaryData task, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.replaceTaskSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", jobId, taskId, "application/json", task, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listSubTasksSinglePageAsync(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSubTasks(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listSubTasksAsync(String jobId, String taskId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listSubTasksSinglePageAsync(jobId, taskId, requestOptions), nextLink -> this.listSubTasksNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listSubTasksSinglePage(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listSubTasksSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listSubTasks(String jobId, String taskId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listSubTasksSinglePage(jobId, taskId, requestOptions), nextLink -> this.listSubTasksNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateTaskWithResponseAsync(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.terminateTask(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.terminateTaskSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> reactivateTaskWithResponseAsync(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reactivateTask(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> reactivateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.reactivateTaskSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTaskFileWithResponseAsync(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteTaskFile(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, filePath, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteTaskFileSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, filePath, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTaskFileWithResponseAsync(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        String accept = "application/octet-stream";
        return FluxUtil.withContext(context -> this.service.getTaskFile(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, filePath, "application/octet-stream", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        String accept = "application/octet-stream";
        return this.service.getTaskFileSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, filePath, "application/octet-stream", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getTaskFilePropertiesWithResponseAsync(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTaskFileProperties(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, filePath, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getTaskFilePropertiesWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getTaskFilePropertiesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, filePath, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listTaskFilesSinglePageAsync(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listTaskFiles(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTaskFilesAsync(String jobId, String taskId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listTaskFilesSinglePageAsync(jobId, taskId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listTaskFilesNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listTaskFilesSinglePage(String jobId, String taskId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listTaskFilesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), jobId, taskId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTaskFiles(String jobId, String taskId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listTaskFilesSinglePage(jobId, taskId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listTaskFilesNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNodeUserWithResponseAsync(String poolId, String nodeId, BinaryData user, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createNodeUser(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, nodeId, "application/json", user, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNodeUserWithResponse(String poolId, String nodeId, BinaryData user, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.createNodeUserSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, nodeId, "application/json", user, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNodeUserWithResponseAsync(String poolId, String nodeId, String userName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteNodeUser(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, userName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNodeUserWithResponse(String poolId, String nodeId, String userName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteNodeUserSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, userName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceNodeUserWithResponseAsync(String poolId, String nodeId, String userName, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replaceNodeUser(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, nodeId, userName, "application/json", content, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceNodeUserWithResponse(String poolId, String nodeId, String userName, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.replaceNodeUserSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, nodeId, userName, "application/json", content, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeWithResponseAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNode(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getNodeSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rebootNodeWithResponseAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return FluxUtil.withContext(context -> this.service.rebootNode(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> rebootNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return this.service.rebootNodeSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startNodeWithResponseAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startNode(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.startNodeSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> reimageNodeWithResponseAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return FluxUtil.withContext(context -> this.service.reimageNode(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> reimageNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return this.service.reimageNodeSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deallocateNodeWithResponseAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return FluxUtil.withContext(context -> this.service.deallocateNode(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deallocateNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return this.service.deallocateNodeSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disableNodeSchedulingWithResponseAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return FluxUtil.withContext(context -> this.service.disableNodeScheduling(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json; odata=minimalmetadata");
            }
        });
        return this.service.disableNodeSchedulingSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableNodeSchedulingWithResponseAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enableNodeScheduling(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.enableNodeSchedulingSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeRemoteLoginSettingsWithResponseAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNodeRemoteLoginSettings(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeRemoteLoginSettingsWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getNodeRemoteLoginSettingsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> uploadNodeLogsWithResponseAsync(String poolId, String nodeId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.uploadNodeLogs(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, nodeId, "application/json", content, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> uploadNodeLogsWithResponse(String poolId, String nodeId, BinaryData content, RequestOptions requestOptions) {
        String contentType = "application/json; odata=minimalmetadata";
        String accept = "application/json";
        return this.service.uploadNodeLogsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json; odata=minimalmetadata", poolId, nodeId, "application/json", content, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listNodesSinglePageAsync(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNodes(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodesAsync(String poolId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodesSinglePageAsync(poolId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodesNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listNodesSinglePage(String poolId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listNodesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodes(String poolId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodesSinglePage(poolId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodesNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeExtensionWithResponseAsync(String poolId, String nodeId, String extensionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNodeExtension(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, extensionName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeExtensionWithResponse(String poolId, String nodeId, String extensionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getNodeExtensionSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, extensionName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listNodeExtensionsSinglePageAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNodeExtensions(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodeExtensionsAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodeExtensionsSinglePageAsync(poolId, nodeId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodeExtensionsNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listNodeExtensionsSinglePage(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listNodeExtensionsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodeExtensions(String poolId, String nodeId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodeExtensionsSinglePage(poolId, nodeId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodeExtensionsNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNodeFileWithResponseAsync(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteNodeFile(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, filePath, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteNodeFileSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, filePath, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeFileWithResponseAsync(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        String accept = "application/octet-stream";
        return FluxUtil.withContext(context -> this.service.getNodeFile(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, filePath, "application/octet-stream", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        String accept = "application/octet-stream";
        return this.service.getNodeFileSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, filePath, "application/octet-stream", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getNodeFilePropertiesWithResponseAsync(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNodeFileProperties(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, filePath, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getNodeFilePropertiesWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getNodeFilePropertiesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, filePath, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listNodeFilesSinglePageAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNodeFiles(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodeFilesAsync(String poolId, String nodeId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodeFilesSinglePageAsync(poolId, nodeId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodeFilesNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listNodeFilesSinglePage(String poolId, String nodeId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listNodeFilesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), poolId, nodeId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodeFiles(String poolId, String nodeId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodeFilesSinglePage(poolId, nodeId, requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxresults", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listNodeFilesNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listApplicationsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listApplicationsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listApplicationsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listApplicationsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listPoolUsageMetricsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPoolUsageMetricsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listPoolUsageMetricsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listPoolUsageMetricsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listPoolsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPoolsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listPoolsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listPoolsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listSupportedImagesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSupportedImagesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listSupportedImagesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listSupportedImagesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listPoolNodeCountsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPoolNodeCountsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listPoolNodeCountsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listPoolNodeCountsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listJobsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listJobsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listJobsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listJobsFromScheduleNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobsFromScheduleNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listJobsFromScheduleNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listJobsFromScheduleNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listJobPreparationAndReleaseTaskStatusNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobPreparationAndReleaseTaskStatusNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listJobPreparationAndReleaseTaskStatusNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listJobPreparationAndReleaseTaskStatusNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listCertificatesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCertificatesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listCertificatesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listCertificatesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listJobSchedulesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobSchedulesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listJobSchedulesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listJobSchedulesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listTasksNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listTasksNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listTasksNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listTasksNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listSubTasksNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSubTasksNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listSubTasksNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listSubTasksNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listTaskFilesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listTaskFilesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listTaskFilesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listTaskFilesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listNodesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNodesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listNodesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listNodesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listNodeExtensionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNodeExtensionsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listNodeExtensionsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listNodeExtensionsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listNodeFilesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNodeFilesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listNodeFilesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listNodeFilesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "odata.nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="BatchClient")
    public static interface BatchClientService {
        @Get(value="/applications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listApplications(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/applications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listApplicationsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/applications/{applicationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getApplication(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="applicationId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/applications/{applicationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getApplicationSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="applicationId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/poolusagemetrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listPoolUsageMetrics(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/poolusagemetrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listPoolUsageMetricsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/pools")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> createPool(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/pools")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> createPoolSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/pools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listPools(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/pools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listPoolsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/pools/{poolId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deletePool(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/pools/{poolId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deletePoolSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Head(value="/pools/{poolId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Boolean>> poolExists(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Head(value="/pools/{poolId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Boolean> poolExistsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/pools/{poolId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getPool(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/pools/{poolId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getPoolSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Patch(value="/pools/{poolId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> updatePool(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/pools/{poolId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> updatePoolSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/disableautoscale")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> disablePoolAutoScale(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/pools/{poolId}/disableautoscale")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> disablePoolAutoScaleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/pools/{poolId}/enableautoscale")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> enablePoolAutoScale(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/enableautoscale")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> enablePoolAutoScaleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/evaluateautoscale")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> evaluatePoolAutoScale(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/evaluateautoscale")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> evaluatePoolAutoScaleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/resize")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> resizePool(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/resize")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> resizePoolSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/stopresize")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> stopPoolResize(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/pools/{poolId}/stopresize")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> stopPoolResizeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/pools/{poolId}/updateproperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> replacePoolProperties(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/updateproperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> replacePoolPropertiesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/removenodes")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeNodes(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/pools/{poolId}/removenodes")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeNodesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Get(value="/supportedimages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listSupportedImages(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/supportedimages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listSupportedImagesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/nodecounts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listPoolNodeCounts(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/nodecounts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listPoolNodeCountsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/jobs/{jobId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteJob(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/jobs/{jobId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteJobSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getJob(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getJobSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Patch(value="/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> updateJob(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> updateJobSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Put(value="/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> replaceJob(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Put(value="/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> replaceJobSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/jobs/{jobId}/disable")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> disableJob(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/jobs/{jobId}/disable")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> disableJobSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/jobs/{jobId}/enable")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> enableJob(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobs/{jobId}/enable")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> enableJobSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobs/{jobId}/terminate")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> terminateJob(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobs/{jobId}/terminate")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> terminateJobSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobs")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> createJob(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/jobs")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> createJobSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/jobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listJobs(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/jobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listJobsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/jobschedules/{jobScheduleId}/jobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listJobsFromSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobschedules/{jobScheduleId}/jobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listJobsFromScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobs/{jobId}/jobpreparationandreleasetaskstatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listJobPreparationAndReleaseTaskStatus(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobs/{jobId}/jobpreparationandreleasetaskstatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listJobPreparationAndReleaseTaskStatusSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobs/{jobId}/taskcounts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getJobTaskCounts(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobs/{jobId}/taskcounts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getJobTaskCountsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/certificates")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> createCertificate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/certificates")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> createCertificateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listCertificates(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listCertificatesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})/canceldelete")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> cancelCertificateDeletion(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="thumbprintAlgorithm") String var3, @PathParam(value="thumbprint") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})/canceldelete")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> cancelCertificateDeletionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="thumbprintAlgorithm") String var3, @PathParam(value="thumbprint") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteCertificate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="thumbprintAlgorithm") String var3, @PathParam(value="thumbprint") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteCertificateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="thumbprintAlgorithm") String var3, @PathParam(value="thumbprint") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="thumbprintAlgorithm") String var3, @PathParam(value="thumbprint") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="thumbprintAlgorithm") String var3, @PathParam(value="thumbprint") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Head(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Boolean>> jobScheduleExists(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Head(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Boolean> jobScheduleExistsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteJobSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteJobScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getJobSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getJobScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Patch(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> updateJobSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobScheduleId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> updateJobScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobScheduleId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Put(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> replaceJobSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobScheduleId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Put(value="/jobschedules/{jobScheduleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> replaceJobScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobScheduleId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/jobschedules/{jobScheduleId}/disable")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> disableJobSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobschedules/{jobScheduleId}/disable")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> disableJobScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobschedules/{jobScheduleId}/enable")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> enableJobSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobschedules/{jobScheduleId}/enable")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> enableJobScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobschedules/{jobScheduleId}/terminate")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> terminateJobSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobschedules/{jobScheduleId}/terminate")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> terminateJobScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobScheduleId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobschedules")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> createJobSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/jobschedules")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> createJobScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/jobschedules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listJobSchedules(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/jobschedules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listJobSchedulesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/jobs/{jobId}/tasks")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> createTask(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/jobs/{jobId}/tasks")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> createTaskSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Get(value="/jobs/{jobId}/tasks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listTasks(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/jobs/{jobId}/tasks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listTasksSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/jobs/{jobId}/addtaskcollection")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createTaskCollection(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/jobs/{jobId}/addtaskcollection")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createTaskCollectionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var6, RequestOptions var7, Context var8);

        @Delete(value="/jobs/{jobId}/tasks/{taskId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteTask(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/jobs/{jobId}/tasks/{taskId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteTaskSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/jobs/{jobId}/tasks/{taskId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getTask(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/jobs/{jobId}/tasks/{taskId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getTaskSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Put(value="/jobs/{jobId}/tasks/{taskId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> replaceTask(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @PathParam(value="taskId") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var7, RequestOptions var8, Context var9);

        @Put(value="/jobs/{jobId}/tasks/{taskId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> replaceTaskSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="jobId") String var4, @PathParam(value="taskId") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var7, RequestOptions var8, Context var9);

        @Get(value="/jobs/{jobId}/tasks/{taskId}/subtasksinfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listSubTasks(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/jobs/{jobId}/tasks/{taskId}/subtasksinfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listSubTasksSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/jobs/{jobId}/tasks/{taskId}/terminate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> terminateTask(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/jobs/{jobId}/tasks/{taskId}/terminate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> terminateTaskSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/jobs/{jobId}/tasks/{taskId}/reactivate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> reactivateTask(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/jobs/{jobId}/tasks/{taskId}/reactivate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> reactivateTaskSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/jobs/{jobId}/tasks/{taskId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteTaskFile(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/jobs/{jobId}/tasks/{taskId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteTaskFileSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/jobs/{jobId}/tasks/{taskId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getTaskFile(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/jobs/{jobId}/tasks/{taskId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getTaskFileSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Head(value="/jobs/{jobId}/tasks/{taskId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> getTaskFileProperties(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Head(value="/jobs/{jobId}/tasks/{taskId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> getTaskFilePropertiesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/jobs/{jobId}/tasks/{taskId}/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listTaskFiles(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/jobs/{jobId}/tasks/{taskId}/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listTaskFilesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") String var3, @PathParam(value="taskId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/users")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> createNodeUser(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @PathParam(value="nodeId") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/users")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> createNodeUserSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @PathParam(value="nodeId") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var7, RequestOptions var8, Context var9);

        @Delete(value="/pools/{poolId}/nodes/{nodeId}/users/{userName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteNodeUser(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="userName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/pools/{poolId}/nodes/{nodeId}/users/{userName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteNodeUserSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="userName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Put(value="/pools/{poolId}/nodes/{nodeId}/users/{userName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> replaceNodeUser(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @PathParam(value="nodeId") String var5, @PathParam(value="userName") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var8, RequestOptions var9, Context var10);

        @Put(value="/pools/{poolId}/nodes/{nodeId}/users/{userName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> replaceNodeUserSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @PathParam(value="nodeId") String var5, @PathParam(value="userName") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var8, RequestOptions var9, Context var10);

        @Get(value="/pools/{poolId}/nodes/{nodeId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getNode(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/pools/{poolId}/nodes/{nodeId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getNodeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/reboot")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> rebootNode(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/reboot")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> rebootNodeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/start")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> startNode(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/start")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> startNodeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/reimage")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> reimageNode(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/reimage")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> reimageNodeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/deallocate")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deallocateNode(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/deallocate")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deallocateNodeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/disablescheduling")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> disableNodeScheduling(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/disablescheduling")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> disableNodeSchedulingSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/enablescheduling")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> enableNodeScheduling(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/enablescheduling")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> enableNodeSchedulingSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/remoteloginsettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getNodeRemoteLoginSettings(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/remoteloginsettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getNodeRemoteLoginSettingsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/uploadbatchservicelogs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> uploadNodeLogs(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @PathParam(value="nodeId") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/pools/{poolId}/nodes/{nodeId}/uploadbatchservicelogs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> uploadNodeLogsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @PathParam(value="poolId") String var4, @PathParam(value="nodeId") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json; odata=minimalmetadata") BinaryData var7, RequestOptions var8, Context var9);

        @Get(value="/pools/{poolId}/nodes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNodes(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/pools/{poolId}/nodes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listNodesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/extensions/{extensionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getNodeExtension(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="extensionName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/extensions/{extensionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getNodeExtensionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="extensionName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNodeExtensions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listNodeExtensionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/pools/{poolId}/nodes/{nodeId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteNodeFile(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/pools/{poolId}/nodes/{nodeId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteNodeFileSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getNodeFile(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getNodeFileSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Head(value="/pools/{poolId}/nodes/{nodeId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> getNodeFileProperties(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Head(value="/pools/{poolId}/nodes/{nodeId}/files/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> getNodeFilePropertiesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @PathParam(value="filePath") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNodeFiles(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/pools/{poolId}/nodes/{nodeId}/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listNodeFilesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="poolId") String var3, @PathParam(value="nodeId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listApplicationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listApplicationsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listPoolUsageMetricsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listPoolUsageMetricsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listPoolsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listPoolsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listSupportedImagesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listSupportedImagesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listPoolNodeCountsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listPoolNodeCountsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listJobsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listJobsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listJobsFromScheduleNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listJobsFromScheduleNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listJobPreparationAndReleaseTaskStatusNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listJobPreparationAndReleaseTaskStatusNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listCertificatesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listCertificatesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listJobSchedulesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listJobSchedulesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listTasksNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listTasksNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listSubTasksNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listSubTasksNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listTaskFilesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listTaskFilesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNodesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listNodesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNodeExtensionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listNodeExtensionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNodeFilesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listNodeFilesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

