/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchClientBuilder;
import com.azure.compute.batch.implementation.BatchClientImpl;
import com.azure.compute.batch.implementation.task.SyncTaskSubmitter;
import com.azure.compute.batch.implementation.task.TaskManager;
import com.azure.compute.batch.models.AutoScaleRun;
import com.azure.compute.batch.models.BatchApplication;
import com.azure.compute.batch.models.BatchCertificate;
import com.azure.compute.batch.models.BatchClientParallelOptions;
import com.azure.compute.batch.models.BatchJob;
import com.azure.compute.batch.models.BatchJobCreateContent;
import com.azure.compute.batch.models.BatchJobDisableContent;
import com.azure.compute.batch.models.BatchJobPreparationAndReleaseTaskStatus;
import com.azure.compute.batch.models.BatchJobSchedule;
import com.azure.compute.batch.models.BatchJobScheduleCreateContent;
import com.azure.compute.batch.models.BatchJobScheduleExistsOptions;
import com.azure.compute.batch.models.BatchJobScheduleUpdateContent;
import com.azure.compute.batch.models.BatchJobTerminateContent;
import com.azure.compute.batch.models.BatchJobUpdateContent;
import com.azure.compute.batch.models.BatchNode;
import com.azure.compute.batch.models.BatchNodeDeallocateContent;
import com.azure.compute.batch.models.BatchNodeDisableSchedulingContent;
import com.azure.compute.batch.models.BatchNodeFile;
import com.azure.compute.batch.models.BatchNodeRebootContent;
import com.azure.compute.batch.models.BatchNodeReimageContent;
import com.azure.compute.batch.models.BatchNodeRemoteLoginSettings;
import com.azure.compute.batch.models.BatchNodeRemoveContent;
import com.azure.compute.batch.models.BatchNodeUserCreateContent;
import com.azure.compute.batch.models.BatchNodeUserUpdateContent;
import com.azure.compute.batch.models.BatchNodeVMExtension;
import com.azure.compute.batch.models.BatchPool;
import com.azure.compute.batch.models.BatchPoolCreateContent;
import com.azure.compute.batch.models.BatchPoolEnableAutoScaleContent;
import com.azure.compute.batch.models.BatchPoolEvaluateAutoScaleContent;
import com.azure.compute.batch.models.BatchPoolExistsOptions;
import com.azure.compute.batch.models.BatchPoolNodeCounts;
import com.azure.compute.batch.models.BatchPoolReplaceContent;
import com.azure.compute.batch.models.BatchPoolResizeContent;
import com.azure.compute.batch.models.BatchPoolUpdateContent;
import com.azure.compute.batch.models.BatchPoolUsageMetrics;
import com.azure.compute.batch.models.BatchSubtask;
import com.azure.compute.batch.models.BatchSupportedImage;
import com.azure.compute.batch.models.BatchTask;
import com.azure.compute.batch.models.BatchTaskAddCollectionResult;
import com.azure.compute.batch.models.BatchTaskCountsResult;
import com.azure.compute.batch.models.BatchTaskCreateContent;
import com.azure.compute.batch.models.BatchTaskGroup;
import com.azure.compute.batch.models.CancelBatchCertificateDeletionOptions;
import com.azure.compute.batch.models.CreateBatchCertificateOptions;
import com.azure.compute.batch.models.CreateBatchJobOptions;
import com.azure.compute.batch.models.CreateBatchJobScheduleOptions;
import com.azure.compute.batch.models.CreateBatchNodeUserOptions;
import com.azure.compute.batch.models.CreateBatchPoolOptions;
import com.azure.compute.batch.models.CreateBatchTaskCollectionOptions;
import com.azure.compute.batch.models.CreateBatchTaskOptions;
import com.azure.compute.batch.models.DeallocateBatchNodeOptions;
import com.azure.compute.batch.models.DeleteBatchCertificateOptions;
import com.azure.compute.batch.models.DeleteBatchJobOptions;
import com.azure.compute.batch.models.DeleteBatchJobScheduleOptions;
import com.azure.compute.batch.models.DeleteBatchNodeFileOptions;
import com.azure.compute.batch.models.DeleteBatchNodeUserOptions;
import com.azure.compute.batch.models.DeleteBatchPoolOptions;
import com.azure.compute.batch.models.DeleteBatchTaskFileOptions;
import com.azure.compute.batch.models.DeleteBatchTaskOptions;
import com.azure.compute.batch.models.DisableBatchJobOptions;
import com.azure.compute.batch.models.DisableBatchJobScheduleOptions;
import com.azure.compute.batch.models.DisableBatchNodeSchedulingOptions;
import com.azure.compute.batch.models.DisableBatchPoolAutoScaleOptions;
import com.azure.compute.batch.models.EnableBatchJobOptions;
import com.azure.compute.batch.models.EnableBatchJobScheduleOptions;
import com.azure.compute.batch.models.EnableBatchNodeSchedulingOptions;
import com.azure.compute.batch.models.EnableBatchPoolAutoScaleOptions;
import com.azure.compute.batch.models.EvaluateBatchPoolAutoScaleOptions;
import com.azure.compute.batch.models.FileResponseHeaderProperties;
import com.azure.compute.batch.models.GetBatchApplicationOptions;
import com.azure.compute.batch.models.GetBatchCertificateOptions;
import com.azure.compute.batch.models.GetBatchJobOptions;
import com.azure.compute.batch.models.GetBatchJobScheduleOptions;
import com.azure.compute.batch.models.GetBatchJobTaskCountsOptions;
import com.azure.compute.batch.models.GetBatchNodeExtensionOptions;
import com.azure.compute.batch.models.GetBatchNodeFileOptions;
import com.azure.compute.batch.models.GetBatchNodeFilePropertiesOptions;
import com.azure.compute.batch.models.GetBatchNodeOptions;
import com.azure.compute.batch.models.GetBatchNodeRemoteLoginSettingsOptions;
import com.azure.compute.batch.models.GetBatchPoolOptions;
import com.azure.compute.batch.models.GetBatchTaskFileOptions;
import com.azure.compute.batch.models.GetBatchTaskFilePropertiesOptions;
import com.azure.compute.batch.models.GetBatchTaskOptions;
import com.azure.compute.batch.models.GetCertificateResponse;
import com.azure.compute.batch.models.ListBatchApplicationsOptions;
import com.azure.compute.batch.models.ListBatchCertificatesOptions;
import com.azure.compute.batch.models.ListBatchJobPreparationAndReleaseTaskStatusOptions;
import com.azure.compute.batch.models.ListBatchJobSchedulesOptions;
import com.azure.compute.batch.models.ListBatchJobsFromScheduleOptions;
import com.azure.compute.batch.models.ListBatchJobsOptions;
import com.azure.compute.batch.models.ListBatchNodeExtensionsOptions;
import com.azure.compute.batch.models.ListBatchNodeFilesOptions;
import com.azure.compute.batch.models.ListBatchNodesOptions;
import com.azure.compute.batch.models.ListBatchPoolNodeCountsOptions;
import com.azure.compute.batch.models.ListBatchPoolUsageMetricsOptions;
import com.azure.compute.batch.models.ListBatchPoolsOptions;
import com.azure.compute.batch.models.ListBatchSubTasksOptions;
import com.azure.compute.batch.models.ListBatchTaskFilesOptions;
import com.azure.compute.batch.models.ListBatchTasksOptions;
import com.azure.compute.batch.models.ListSupportedBatchImagesOptions;
import com.azure.compute.batch.models.ReactivateBatchTaskOptions;
import com.azure.compute.batch.models.RebootBatchNodeOptions;
import com.azure.compute.batch.models.ReimageBatchNodeOptions;
import com.azure.compute.batch.models.RemoveBatchNodesOptions;
import com.azure.compute.batch.models.ReplaceBatchJobOptions;
import com.azure.compute.batch.models.ReplaceBatchJobScheduleOptions;
import com.azure.compute.batch.models.ReplaceBatchNodeUserOptions;
import com.azure.compute.batch.models.ReplaceBatchPoolPropertiesOptions;
import com.azure.compute.batch.models.ReplaceBatchTaskOptions;
import com.azure.compute.batch.models.ResizeBatchPoolOptions;
import com.azure.compute.batch.models.StartBatchNodeOptions;
import com.azure.compute.batch.models.StopBatchPoolResizeOptions;
import com.azure.compute.batch.models.TerminateBatchJobOptions;
import com.azure.compute.batch.models.TerminateBatchJobScheduleOptions;
import com.azure.compute.batch.models.TerminateBatchTaskOptions;
import com.azure.compute.batch.models.UpdateBatchJobOptions;
import com.azure.compute.batch.models.UpdateBatchJobScheduleOptions;
import com.azure.compute.batch.models.UpdateBatchPoolOptions;
import com.azure.compute.batch.models.UploadBatchNodeLogsOptions;
import com.azure.compute.batch.models.UploadBatchServiceLogsContent;
import com.azure.compute.batch.models.UploadBatchServiceLogsResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=BatchClientBuilder.class)
public final class BatchClient {
    private final BatchClientImpl serviceClient;

    BatchClient(BatchClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createTasks(String jobId, List<BatchTaskCreateContent> taskList) {
        this.createTasks(jobId, taskList, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createTasks(String jobId, List<BatchTaskCreateContent> taskList, BatchClientParallelOptions batchClientParallelOptions) {
        SyncTaskSubmitter taskSubmitter = new SyncTaskSubmitter(this);
        TaskManager.createTasks(taskSubmitter, jobId, taskList, batchClientParallelOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listApplications(RequestOptions requestOptions) {
        return this.serviceClient.listApplications(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getApplicationWithResponse(String applicationId, RequestOptions requestOptions) {
        return this.serviceClient.getApplicationWithResponse(applicationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPoolUsageMetrics(RequestOptions requestOptions) {
        return this.serviceClient.listPoolUsageMetrics(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createPoolWithResponse(BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.createPoolWithResponse(pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPools(RequestOptions requestOptions) {
        return this.serviceClient.listPools(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePoolWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.deletePoolWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> poolExistsWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.poolExistsWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getPoolWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.getPoolWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updatePoolWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.updatePoolWithResponse(poolId, pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disablePoolAutoScaleWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.disablePoolAutoScaleWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enablePoolAutoScaleWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.enablePoolAutoScaleWithResponse(poolId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> evaluatePoolAutoScaleWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.evaluatePoolAutoScaleWithResponse(poolId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resizePoolWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.resizePoolWithResponse(poolId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopPoolResizeWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.stopPoolResizeWithResponse(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replacePoolPropertiesWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.replacePoolPropertiesWithResponse(poolId, pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeNodesWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.removeNodesWithResponse(poolId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listSupportedImages(RequestOptions requestOptions) {
        return this.serviceClient.listSupportedImages(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPoolNodeCounts(RequestOptions requestOptions) {
        return this.serviceClient.listPoolNodeCounts(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.deleteJobWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.getJobWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.updateJobWithResponse(jobId, job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.replaceJobWithResponse(jobId, job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disableJobWithResponse(String jobId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.disableJobWithResponse(jobId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.enableJobWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.terminateJobWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createJobWithResponse(BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.createJobWithResponse(job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobs(RequestOptions requestOptions) {
        return this.serviceClient.listJobs(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobsFromSchedule(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.listJobsFromSchedule(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobPreparationAndReleaseTaskStatus(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobTaskCountsWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.getJobTaskCountsWithResponse(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createCertificateWithResponse(BinaryData certificate, RequestOptions requestOptions) {
        return this.serviceClient.createCertificateWithResponse(certificate, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listCertificates(RequestOptions requestOptions) {
        return this.serviceClient.listCertificates(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelCertificateDeletionWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> jobScheduleExistsWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.jobScheduleExistsWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.deleteJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.getJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.updateJobScheduleWithResponse(jobScheduleId, jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.replaceJobScheduleWithResponse(jobScheduleId, jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.disableJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.enableJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.terminateJobScheduleWithResponse(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createJobScheduleWithResponse(BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.createJobScheduleWithResponse(jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listJobSchedules(RequestOptions requestOptions) {
        return this.serviceClient.listJobSchedules(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createTaskWithResponse(String jobId, BinaryData task, RequestOptions requestOptions) {
        return this.serviceClient.createTaskWithResponse(jobId, task, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTasks(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.listTasks(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createTaskCollectionWithResponse(String jobId, BinaryData taskCollection, RequestOptions requestOptions) {
        return this.serviceClient.createTaskCollectionWithResponse(jobId, taskCollection, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTaskWithResponse(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.getTaskWithResponse(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceTaskWithResponse(String jobId, String taskId, BinaryData task, RequestOptions requestOptions) {
        return this.serviceClient.replaceTaskWithResponse(jobId, taskId, task, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listSubTasks(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.listSubTasks(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.terminateTaskWithResponse(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> reactivateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.reactivateTaskWithResponse(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getTaskFilePropertiesWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTaskFiles(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.listTaskFiles(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNodeUserWithResponse(String poolId, String nodeId, BinaryData user, RequestOptions requestOptions) {
        return this.serviceClient.createNodeUserWithResponse(poolId, nodeId, user, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNodeUserWithResponse(String poolId, String nodeId, String userName, RequestOptions requestOptions) {
        return this.serviceClient.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> replaceNodeUserWithResponse(String poolId, String nodeId, String userName, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.replaceNodeUserWithResponse(poolId, nodeId, userName, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.getNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> rebootNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.rebootNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.startNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> reimageNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.reimageNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deallocateNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.deallocateNodeWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> disableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeRemoteLoginSettingsWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> uploadNodeLogsWithResponse(String poolId, String nodeId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.uploadNodeLogsWithResponse(poolId, nodeId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodes(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.listNodes(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeExtensionWithResponse(String poolId, String nodeId, String extensionName, RequestOptions requestOptions) {
        return this.serviceClient.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodeExtensions(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.listNodeExtensions(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getNodeFilePropertiesWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNodeFiles(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.listNodeFiles(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchApplication> listApplications(ListBatchApplicationsOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.serviceClient.listApplications(requestOptions).mapPage(bodyItemValue -> (BatchApplication)bodyItemValue.toObject(BatchApplication.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchApplication> listApplications() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listApplications(requestOptions).mapPage(bodyItemValue -> (BatchApplication)bodyItemValue.toObject(BatchApplication.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchApplication getApplication(String applicationId, GetBatchApplicationOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return (BatchApplication)((BinaryData)this.getApplicationWithResponse(applicationId, requestOptions).getValue()).toObject(BatchApplication.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchApplication getApplication(String applicationId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchApplication)((BinaryData)this.getApplicationWithResponse(applicationId, requestOptions).getValue()).toObject(BatchApplication.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPoolUsageMetrics> listPoolUsageMetrics(ListBatchPoolUsageMetricsOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime startTime = options == null ? null : options.getStartTime();
        OffsetDateTime endtime = options == null ? null : options.getEndtime();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (startTime != null) {
            requestOptions.addQueryParam("startTime", String.valueOf(startTime), false);
        }
        if (endtime != null) {
            requestOptions.addQueryParam("endtime", String.valueOf(endtime), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        return this.serviceClient.listPoolUsageMetrics(requestOptions).mapPage(bodyItemValue -> (BatchPoolUsageMetrics)bodyItemValue.toObject(BatchPoolUsageMetrics.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPoolUsageMetrics> listPoolUsageMetrics() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listPoolUsageMetrics(requestOptions).mapPage(bodyItemValue -> (BatchPoolUsageMetrics)bodyItemValue.toObject(BatchPoolUsageMetrics.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createPool(BatchPoolCreateContent pool, CreateBatchPoolOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.createPoolWithResponse(BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createPool(BatchPoolCreateContent pool) {
        RequestOptions requestOptions = new RequestOptions();
        this.createPoolWithResponse(BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPool> listPools(ListBatchPoolsOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listPools(requestOptions).mapPage(bodyItemValue -> (BatchPool)bodyItemValue.toObject(BatchPool.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPool> listPools() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listPools(requestOptions).mapPage(bodyItemValue -> (BatchPool)bodyItemValue.toObject(BatchPool.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePool(String poolId, DeleteBatchPoolOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.deletePoolWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deletePoolWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean poolExists(String poolId, BatchPoolExistsOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (Boolean)this.poolExistsWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean poolExists(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Boolean)this.poolExistsWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchPool getPool(String poolId, GetBatchPoolOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (BatchPool)((BinaryData)this.getPoolWithResponse(poolId, requestOptions).getValue()).toObject(BatchPool.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchPool getPool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchPool)((BinaryData)this.getPoolWithResponse(poolId, requestOptions).getValue()).toObject(BatchPool.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updatePool(String poolId, BatchPoolUpdateContent pool, UpdateBatchPoolOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.updatePoolWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updatePool(String poolId, BatchPoolUpdateContent pool) {
        RequestOptions requestOptions = new RequestOptions();
        this.updatePoolWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disablePoolAutoScale(String poolId, DisableBatchPoolAutoScaleOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.disablePoolAutoScaleWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disablePoolAutoScale(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        this.disablePoolAutoScaleWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enablePoolAutoScale(String poolId, BatchPoolEnableAutoScaleContent content, EnableBatchPoolAutoScaleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.enablePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enablePoolAutoScale(String poolId, BatchPoolEnableAutoScaleContent content) {
        RequestOptions requestOptions = new RequestOptions();
        this.enablePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoScaleRun evaluatePoolAutoScale(String poolId, BatchPoolEvaluateAutoScaleContent content, EvaluateBatchPoolAutoScaleOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return (AutoScaleRun)((BinaryData)this.evaluatePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).getValue()).toObject(AutoScaleRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoScaleRun evaluatePoolAutoScale(String poolId, BatchPoolEvaluateAutoScaleContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return (AutoScaleRun)((BinaryData)this.evaluatePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).getValue()).toObject(AutoScaleRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resizePool(String poolId, BatchPoolResizeContent content, ResizeBatchPoolOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.resizePoolWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resizePool(String poolId, BatchPoolResizeContent content) {
        RequestOptions requestOptions = new RequestOptions();
        this.resizePoolWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopPoolResize(String poolId, StopBatchPoolResizeOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.stopPoolResizeWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopPoolResize(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        this.stopPoolResizeWithResponse(poolId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replacePoolProperties(String poolId, BatchPoolReplaceContent pool, ReplaceBatchPoolPropertiesOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.replacePoolPropertiesWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replacePoolProperties(String poolId, BatchPoolReplaceContent pool) {
        RequestOptions requestOptions = new RequestOptions();
        this.replacePoolPropertiesWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeNodes(String poolId, BatchNodeRemoveContent content, RemoveBatchNodesOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.removeNodesWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeNodes(String poolId, BatchNodeRemoveContent content) {
        RequestOptions requestOptions = new RequestOptions();
        this.removeNodesWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchSupportedImage> listSupportedImages(ListSupportedBatchImagesOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        return this.serviceClient.listSupportedImages(requestOptions).mapPage(bodyItemValue -> (BatchSupportedImage)bodyItemValue.toObject(BatchSupportedImage.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchSupportedImage> listSupportedImages() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listSupportedImages(requestOptions).mapPage(bodyItemValue -> (BatchSupportedImage)bodyItemValue.toObject(BatchSupportedImage.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPoolNodeCounts> listPoolNodeCounts(ListBatchPoolNodeCountsOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        return this.serviceClient.listPoolNodeCounts(requestOptions).mapPage(bodyItemValue -> (BatchPoolNodeCounts)bodyItemValue.toObject(BatchPoolNodeCounts.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchPoolNodeCounts> listPoolNodeCounts() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listPoolNodeCounts(requestOptions).mapPage(bodyItemValue -> (BatchPoolNodeCounts)bodyItemValue.toObject(BatchPoolNodeCounts.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteJob(String jobId, DeleteBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.deleteJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchJob getJob(String jobId, GetBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (BatchJob)((BinaryData)this.getJobWithResponse(jobId, requestOptions).getValue()).toObject(BatchJob.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchJob getJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchJob)((BinaryData)this.getJobWithResponse(jobId, requestOptions).getValue()).toObject(BatchJob.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateJob(String jobId, BatchJobUpdateContent job, UpdateBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.updateJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateJob(String jobId, BatchJobUpdateContent job) {
        RequestOptions requestOptions = new RequestOptions();
        this.updateJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceJob(String jobId, BatchJob job, ReplaceBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.replaceJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceJob(String jobId, BatchJob job) {
        RequestOptions requestOptions = new RequestOptions();
        this.replaceJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableJob(String jobId, BatchJobDisableContent content, DisableBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.disableJobWithResponse(jobId, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableJob(String jobId, BatchJobDisableContent content) {
        RequestOptions requestOptions = new RequestOptions();
        this.disableJobWithResponse(jobId, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableJob(String jobId, EnableBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.enableJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        this.enableJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateJob(String jobId, TerminateBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchJobTerminateContent parameters = options == null ? null : options.getParameters();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.terminateJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        this.terminateJobWithResponse(jobId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createJob(BatchJobCreateContent job, CreateBatchJobOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.createJobWithResponse(BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createJob(BatchJobCreateContent job) {
        RequestOptions requestOptions = new RequestOptions();
        this.createJobWithResponse(BinaryData.fromObject((Object)job), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJob> listJobs(ListBatchJobsOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listJobs(requestOptions).mapPage(bodyItemValue -> (BatchJob)bodyItemValue.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJob> listJobs() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listJobs(requestOptions).mapPage(bodyItemValue -> (BatchJob)bodyItemValue.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJob> listJobsFromSchedule(String jobScheduleId, ListBatchJobsFromScheduleOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listJobsFromSchedule(jobScheduleId, requestOptions).mapPage(bodyItemValue -> (BatchJob)bodyItemValue.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJob> listJobsFromSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listJobsFromSchedule(jobScheduleId, requestOptions).mapPage(bodyItemValue -> (BatchJob)bodyItemValue.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJobPreparationAndReleaseTaskStatus> listJobPreparationAndReleaseTaskStatus(String jobId, ListBatchJobPreparationAndReleaseTaskStatusOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions).mapPage(bodyItemValue -> (BatchJobPreparationAndReleaseTaskStatus)bodyItemValue.toObject(BatchJobPreparationAndReleaseTaskStatus.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJobPreparationAndReleaseTaskStatus> listJobPreparationAndReleaseTaskStatus(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions).mapPage(bodyItemValue -> (BatchJobPreparationAndReleaseTaskStatus)bodyItemValue.toObject(BatchJobPreparationAndReleaseTaskStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTaskCountsResult getJobTaskCounts(String jobId, GetBatchJobTaskCountsOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return (BatchTaskCountsResult)((BinaryData)this.getJobTaskCountsWithResponse(jobId, requestOptions).getValue()).toObject(BatchTaskCountsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTaskCountsResult getJobTaskCounts(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchTaskCountsResult)((BinaryData)this.getJobTaskCountsWithResponse(jobId, requestOptions).getValue()).toObject(BatchTaskCountsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createCertificate(BatchCertificate certificate, CreateBatchCertificateOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.createCertificateWithResponse(BinaryData.fromObject((Object)certificate), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createCertificate(BatchCertificate certificate) {
        RequestOptions requestOptions = new RequestOptions();
        this.createCertificateWithResponse(BinaryData.fromObject((Object)certificate), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchCertificate> listCertificates(ListBatchCertificatesOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listCertificates(requestOptions).mapPage(bodyItemValue -> (BatchCertificate)bodyItemValue.toObject(BatchCertificate.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchCertificate> listCertificates() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listCertificates(requestOptions).mapPage(bodyItemValue -> (BatchCertificate)bodyItemValue.toObject(BatchCertificate.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelCertificateDeletion(String thumbprintAlgorithm, String thumbprint, CancelBatchCertificateDeletionOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelCertificateDeletion(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        this.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteCertificate(String thumbprintAlgorithm, String thumbprint, DeleteBatchCertificateOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetCertificateResponse getCertificate(String thumbprintAlgorithm, String thumbprint, GetBatchCertificateOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return (GetCertificateResponse)((BinaryData)this.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue()).toObject(GetCertificateResponse.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetCertificateResponse getCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        return (GetCertificateResponse)((BinaryData)this.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).getValue()).toObject(GetCertificateResponse.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean jobScheduleExists(String jobScheduleId, BatchJobScheduleExistsOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (Boolean)this.jobScheduleExistsWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean jobScheduleExists(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Boolean)this.jobScheduleExistsWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteJobSchedule(String jobScheduleId, DeleteBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.deleteJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchJobSchedule getJobSchedule(String jobScheduleId, GetBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (BatchJobSchedule)((BinaryData)this.getJobScheduleWithResponse(jobScheduleId, requestOptions).getValue()).toObject(BatchJobSchedule.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchJobSchedule getJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchJobSchedule)((BinaryData)this.getJobScheduleWithResponse(jobScheduleId, requestOptions).getValue()).toObject(BatchJobSchedule.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateJobSchedule(String jobScheduleId, BatchJobScheduleUpdateContent jobSchedule, UpdateBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.updateJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateJobSchedule(String jobScheduleId, BatchJobScheduleUpdateContent jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        this.updateJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceJobSchedule(String jobScheduleId, BatchJobSchedule jobSchedule, ReplaceBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.replaceJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceJobSchedule(String jobScheduleId, BatchJobSchedule jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        this.replaceJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableJobSchedule(String jobScheduleId, DisableBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.disableJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        this.disableJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableJobSchedule(String jobScheduleId, EnableBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.enableJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        this.enableJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateJobSchedule(String jobScheduleId, TerminateBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.terminateJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        this.terminateJobScheduleWithResponse(jobScheduleId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createJobSchedule(BatchJobScheduleCreateContent jobSchedule, CreateBatchJobScheduleOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.createJobScheduleWithResponse(BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createJobSchedule(BatchJobScheduleCreateContent jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        this.createJobScheduleWithResponse(BinaryData.fromObject((Object)jobSchedule), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJobSchedule> listJobSchedules(ListBatchJobSchedulesOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listJobSchedules(requestOptions).mapPage(bodyItemValue -> (BatchJobSchedule)bodyItemValue.toObject(BatchJobSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchJobSchedule> listJobSchedules() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listJobSchedules(requestOptions).mapPage(bodyItemValue -> (BatchJobSchedule)bodyItemValue.toObject(BatchJobSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createTask(String jobId, BatchTaskCreateContent task, CreateBatchTaskOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.createTaskWithResponse(jobId, BinaryData.fromObject((Object)task), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createTask(String jobId, BatchTaskCreateContent task) {
        RequestOptions requestOptions = new RequestOptions();
        this.createTaskWithResponse(jobId, BinaryData.fromObject((Object)task), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchTask> listTasks(String jobId, ListBatchTasksOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listTasks(jobId, requestOptions).mapPage(bodyItemValue -> (BatchTask)bodyItemValue.toObject(BatchTask.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchTask> listTasks(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTasks(jobId, requestOptions).mapPage(bodyItemValue -> (BatchTask)bodyItemValue.toObject(BatchTask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTaskAddCollectionResult createTaskCollection(String jobId, BatchTaskGroup taskCollection, CreateBatchTaskCollectionOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return (BatchTaskAddCollectionResult)((BinaryData)this.createTaskCollectionWithResponse(jobId, BinaryData.fromObject((Object)taskCollection), requestOptions).getValue()).toObject(BatchTaskAddCollectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTaskAddCollectionResult createTaskCollection(String jobId, BatchTaskGroup taskCollection) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchTaskAddCollectionResult)((BinaryData)this.createTaskCollectionWithResponse(jobId, BinaryData.fromObject((Object)taskCollection), requestOptions).getValue()).toObject(BatchTaskAddCollectionResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTask(String jobId, String taskId, DeleteBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.deleteTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTask getTask(String jobId, String taskId, GetBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return (BatchTask)((BinaryData)this.getTaskWithResponse(jobId, taskId, requestOptions).getValue()).toObject(BatchTask.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchTask getTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchTask)((BinaryData)this.getTaskWithResponse(jobId, taskId, requestOptions).getValue()).toObject(BatchTask.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceTask(String jobId, String taskId, BatchTask task, ReplaceBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.replaceTaskWithResponse(jobId, taskId, BinaryData.fromObject((Object)task), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceTask(String jobId, String taskId, BatchTask task) {
        RequestOptions requestOptions = new RequestOptions();
        this.replaceTaskWithResponse(jobId, taskId, BinaryData.fromObject((Object)task), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchSubtask> listSubTasks(String jobId, String taskId, ListBatchSubTasksOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listSubTasks(jobId, taskId, requestOptions).mapPage(bodyItemValue -> (BatchSubtask)bodyItemValue.toObject(BatchSubtask.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchSubtask> listSubTasks(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listSubTasks(jobId, taskId, requestOptions).mapPage(bodyItemValue -> (BatchSubtask)bodyItemValue.toObject(BatchSubtask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateTask(String jobId, String taskId, TerminateBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.terminateTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        this.terminateTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reactivateTask(String jobId, String taskId, ReactivateBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        this.reactivateTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reactivateTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        this.reactivateTaskWithResponse(jobId, taskId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTaskFile(String jobId, String taskId, String filePath, DeleteBatchTaskFileOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        this.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTaskFile(String jobId, String taskId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getTaskFile(String jobId, String taskId, String filePath, GetBatchTaskFileOptions options) {
        String ocpRange;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        String string = ocpRange = options == null ? null : options.getOcpRange();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ocpRange != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"ocp-range"), ocpRange);
        }
        return (BinaryData)this.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getTaskFile(String jobId, String taskId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileResponseHeaderProperties getTaskFileProperties(String jobId, String taskId, String filePath, GetBatchTaskFilePropertiesOptions options) {
        OffsetDateTime ifUnmodifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime offsetDateTime = ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        Response<Void> response = this.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, requestOptions);
        return new FileResponseHeaderProperties(response.getHeaders());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileResponseHeaderProperties getTaskFileProperties(String jobId, String taskId, String filePath) {
        Response<Void> response = this.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, new RequestOptions());
        return new FileResponseHeaderProperties(response.getHeaders());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeFile> listTaskFiles(String jobId, String taskId, ListBatchTaskFilesOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        return this.serviceClient.listTaskFiles(jobId, taskId, requestOptions).mapPage(bodyItemValue -> (BatchNodeFile)bodyItemValue.toObject(BatchNodeFile.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeFile> listTaskFiles(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTaskFiles(jobId, taskId, requestOptions).mapPage(bodyItemValue -> (BatchNodeFile)bodyItemValue.toObject(BatchNodeFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createNodeUser(String poolId, String nodeId, BatchNodeUserCreateContent user, CreateBatchNodeUserOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.createNodeUserWithResponse(poolId, nodeId, BinaryData.fromObject((Object)user), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createNodeUser(String poolId, String nodeId, BatchNodeUserCreateContent user) {
        RequestOptions requestOptions = new RequestOptions();
        this.createNodeUserWithResponse(poolId, nodeId, BinaryData.fromObject((Object)user), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNodeUser(String poolId, String nodeId, String userName, DeleteBatchNodeUserOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNodeUser(String poolId, String nodeId, String userName) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceNodeUser(String poolId, String nodeId, String userName, BatchNodeUserUpdateContent content, ReplaceBatchNodeUserOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.replaceNodeUserWithResponse(poolId, nodeId, userName, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void replaceNodeUser(String poolId, String nodeId, String userName, BatchNodeUserUpdateContent content) {
        RequestOptions requestOptions = new RequestOptions();
        this.replaceNodeUserWithResponse(poolId, nodeId, userName, BinaryData.fromObject((Object)content), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNode getNode(String poolId, String nodeId, GetBatchNodeOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return (BatchNode)((BinaryData)this.getNodeWithResponse(poolId, nodeId, requestOptions).getValue()).toObject(BatchNode.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNode getNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchNode)((BinaryData)this.getNodeWithResponse(poolId, nodeId, requestOptions).getValue()).toObject(BatchNode.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rebootNode(String poolId, String nodeId, RebootBatchNodeOptions options) {
        BatchNodeRebootContent parameters;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeRebootContent batchNodeRebootContent = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        this.rebootNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rebootNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.rebootNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startNode(String poolId, String nodeId, StartBatchNodeOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.startNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.startNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reimageNode(String poolId, String nodeId, ReimageBatchNodeOptions options) {
        BatchNodeReimageContent parameters;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeReimageContent batchNodeReimageContent = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        this.reimageNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reimageNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.reimageNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deallocateNode(String poolId, String nodeId, DeallocateBatchNodeOptions options) {
        BatchNodeDeallocateContent parameters;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDeallocateContent batchNodeDeallocateContent = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        this.deallocateNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deallocateNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deallocateNodeWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableNodeScheduling(String poolId, String nodeId, DisableBatchNodeSchedulingOptions options) {
        BatchNodeDisableSchedulingContent parameters;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDisableSchedulingContent batchNodeDisableSchedulingContent = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        this.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableNodeScheduling(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableNodeScheduling(String poolId, String nodeId, EnableBatchNodeSchedulingOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        this.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableNodeScheduling(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        this.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNodeRemoteLoginSettings getNodeRemoteLoginSettings(String poolId, String nodeId, GetBatchNodeRemoteLoginSettingsOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return (BatchNodeRemoteLoginSettings)((BinaryData)this.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions).getValue()).toObject(BatchNodeRemoteLoginSettings.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNodeRemoteLoginSettings getNodeRemoteLoginSettings(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchNodeRemoteLoginSettings)((BinaryData)this.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions).getValue()).toObject(BatchNodeRemoteLoginSettings.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UploadBatchServiceLogsResult uploadNodeLogs(String poolId, String nodeId, UploadBatchServiceLogsContent content, UploadBatchNodeLogsOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return (UploadBatchServiceLogsResult)((BinaryData)this.uploadNodeLogsWithResponse(poolId, nodeId, BinaryData.fromObject((Object)content), requestOptions).getValue()).toObject(UploadBatchServiceLogsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UploadBatchServiceLogsResult uploadNodeLogs(String poolId, String nodeId, UploadBatchServiceLogsContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return (UploadBatchServiceLogsResult)((BinaryData)this.uploadNodeLogsWithResponse(poolId, nodeId, BinaryData.fromObject((Object)content), requestOptions).getValue()).toObject(UploadBatchServiceLogsResult.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNode> listNodes(String poolId, ListBatchNodesOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listNodes(poolId, requestOptions).mapPage(bodyItemValue -> (BatchNode)bodyItemValue.toObject(BatchNode.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNode> listNodes(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listNodes(poolId, requestOptions).mapPage(bodyItemValue -> (BatchNode)bodyItemValue.toObject(BatchNode.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNodeVMExtension getNodeExtension(String poolId, String nodeId, String extensionName, GetBatchNodeExtensionOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return (BatchNodeVMExtension)((BinaryData)this.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions).getValue()).toObject(BatchNodeVMExtension.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchNodeVMExtension getNodeExtension(String poolId, String nodeId, String extensionName) {
        RequestOptions requestOptions = new RequestOptions();
        return (BatchNodeVMExtension)((BinaryData)this.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions).getValue()).toObject(BatchNodeVMExtension.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeVMExtension> listNodeExtensions(String poolId, String nodeId, ListBatchNodeExtensionsOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listNodeExtensions(poolId, nodeId, requestOptions).mapPage(bodyItemValue -> (BatchNodeVMExtension)bodyItemValue.toObject(BatchNodeVMExtension.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeVMExtension> listNodeExtensions(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listNodeExtensions(poolId, nodeId, requestOptions).mapPage(bodyItemValue -> (BatchNodeVMExtension)bodyItemValue.toObject(BatchNodeVMExtension.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNodeFile(String poolId, String nodeId, String filePath, DeleteBatchNodeFileOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        this.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNodeFile(String poolId, String nodeId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getNodeFile(String poolId, String nodeId, String filePath, GetBatchNodeFileOptions options) {
        String ocpRange;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        String string = ocpRange = options == null ? null : options.getOcpRange();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ocpRange != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"ocp-range"), ocpRange);
        }
        return (BinaryData)this.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getNodeFile(String poolId, String nodeId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileResponseHeaderProperties getNodeFileProperties(String poolId, String nodeId, String filePath, GetBatchNodeFilePropertiesOptions options) {
        OffsetDateTime ifUnmodifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime offsetDateTime = ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        Response<Void> response = this.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, requestOptions);
        return new FileResponseHeaderProperties(response.getHeaders());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileResponseHeaderProperties getNodeFileProperties(String poolId, String nodeId, String filePath) {
        Response<Void> response = this.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, new RequestOptions());
        return new FileResponseHeaderProperties(response.getHeaders());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeFile> listNodeFiles(String poolId, String nodeId, ListBatchNodeFilesOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        return this.serviceClient.listNodeFiles(poolId, nodeId, requestOptions).mapPage(bodyItemValue -> (BatchNodeFile)bodyItemValue.toObject(BatchNodeFile.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BatchNodeFile> listNodeFiles(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listNodeFiles(poolId, nodeId, requestOptions).mapPage(bodyItemValue -> (BatchNodeFile)bodyItemValue.toObject(BatchNodeFile.class));
    }
}

