/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.DatasetReference;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.analytics.synapse.artifacts.models.WebActivityAuthentication;
import com.azure.analytics.synapse.artifacts.models.WebActivityMethod;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WebActivity
extends ExecutionActivity {
    private String type = "WebActivity";
    private WebActivityMethod method;
    private Object url;
    private Object headers;
    private Object body;
    private WebActivityAuthentication authentication;
    private List<DatasetReference> datasets;
    private List<LinkedServiceReference> linkedServices;
    private IntegrationRuntimeReference connectVia;

    @Override
    public String getType() {
        return this.type;
    }

    public WebActivityMethod getMethod() {
        return this.method;
    }

    public WebActivity setMethod(WebActivityMethod method) {
        this.method = method;
        return this;
    }

    public Object getUrl() {
        return this.url;
    }

    public WebActivity setUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object getHeaders() {
        return this.headers;
    }

    public WebActivity setHeaders(Object headers) {
        this.headers = headers;
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public WebActivity setBody(Object body) {
        this.body = body;
        return this;
    }

    public WebActivityAuthentication getAuthentication() {
        return this.authentication;
    }

    public WebActivity setAuthentication(WebActivityAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public List<DatasetReference> getDatasets() {
        return this.datasets;
    }

    public WebActivity setDatasets(List<DatasetReference> datasets) {
        this.datasets = datasets;
        return this;
    }

    public List<LinkedServiceReference> getLinkedServices() {
        return this.linkedServices;
    }

    public WebActivity setLinkedServices(List<LinkedServiceReference> linkedServices) {
        this.linkedServices = linkedServices;
        return this;
    }

    public IntegrationRuntimeReference getConnectVia() {
        return this.connectVia;
    }

    public WebActivity setConnectVia(IntegrationRuntimeReference connectVia) {
        this.connectVia = connectVia;
        return this;
    }

    @Override
    public WebActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public WebActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public WebActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public WebActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public WebActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public WebActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public WebActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public WebActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.method != null || this.url != null || this.headers != null || this.body != null || this.authentication != null || this.datasets != null || this.linkedServices != null || this.connectVia != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
            jsonWriter.writeUntypedField("url", this.url);
            if (this.headers != null) {
                jsonWriter.writeUntypedField("headers", this.headers);
            }
            if (this.body != null) {
                jsonWriter.writeUntypedField("body", this.body);
            }
            jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
            jsonWriter.writeArrayField("datasets", this.datasets, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("linkedServices", this.linkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WebActivity fromJson(JsonReader jsonReader) throws IOException {
        return (WebActivity)jsonReader.readObject(reader -> {
            WebActivity deserializedWebActivity = new WebActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWebActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWebActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWebActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedWebActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedWebActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedWebActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedWebActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedWebActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("method".equals(fieldName)) {
                            deserializedWebActivity.method = WebActivityMethod.fromString(reader.getString());
                            continue;
                        }
                        if ("url".equals(fieldName)) {
                            deserializedWebActivity.url = reader.readUntyped();
                            continue;
                        }
                        if ("headers".equals(fieldName)) {
                            deserializedWebActivity.headers = reader.readUntyped();
                            continue;
                        }
                        if ("body".equals(fieldName)) {
                            deserializedWebActivity.body = reader.readUntyped();
                            continue;
                        }
                        if ("authentication".equals(fieldName)) {
                            deserializedWebActivity.authentication = WebActivityAuthentication.fromJson(reader);
                            continue;
                        }
                        if ("datasets".equals(fieldName)) {
                            List datasets;
                            deserializedWebActivity.datasets = datasets = reader.readArray(reader1 -> DatasetReference.fromJson(reader1));
                            continue;
                        }
                        if ("linkedServices".equals(fieldName)) {
                            List linkedServices;
                            deserializedWebActivity.linkedServices = linkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                            continue;
                        }
                        if ("connectVia".equals(fieldName)) {
                            deserializedWebActivity.connectVia = IntegrationRuntimeReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWebActivity.setAdditionalProperties(additionalProperties);
            return deserializedWebActivity;
        });
    }
}

