/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.WarehouseAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WarehouseLinkedService
extends LinkedService {
    private String type = "Warehouse";
    private Object artifactId;
    private Object endpoint;
    private Object workspaceId;
    private WarehouseAuthenticationType authenticationType;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private String encryptedCredential;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getArtifactId() {
        return this.artifactId;
    }

    public WarehouseLinkedService setArtifactId(Object artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public WarehouseLinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object getWorkspaceId() {
        return this.workspaceId;
    }

    public WarehouseLinkedService setWorkspaceId(Object workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public WarehouseAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public WarehouseLinkedService setAuthenticationType(WarehouseAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public WarehouseLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public WarehouseLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public WarehouseLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public String getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public WarehouseLinkedService setEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public WarehouseLinkedService setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public WarehouseLinkedService setServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public WarehouseLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public WarehouseLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public WarehouseLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public WarehouseLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public WarehouseLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public WarehouseLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.artifactId != null || this.endpoint != null || this.workspaceId != null || this.authenticationType != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.tenant != null || this.encryptedCredential != null || this.servicePrincipalCredentialType != null || this.servicePrincipalCredential != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("artifactId", this.artifactId);
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            if (this.workspaceId != null) {
                jsonWriter.writeUntypedField("workspaceId", this.workspaceId);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
            if (this.servicePrincipalCredentialType != null) {
                jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
            }
            jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WarehouseLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (WarehouseLinkedService)jsonReader.readObject(reader -> {
            WarehouseLinkedService deserializedWarehouseLinkedService = new WarehouseLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedWarehouseLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedWarehouseLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWarehouseLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedWarehouseLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedWarehouseLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWarehouseLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("artifactId".equals(fieldName)) {
                            deserializedWarehouseLinkedService.artifactId = reader.readUntyped();
                            continue;
                        }
                        if ("endpoint".equals(fieldName)) {
                            deserializedWarehouseLinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("workspaceId".equals(fieldName)) {
                            deserializedWarehouseLinkedService.workspaceId = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedWarehouseLinkedService.authenticationType = WarehouseAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedWarehouseLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedWarehouseLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedWarehouseLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedWarehouseLinkedService.encryptedCredential = reader.getString();
                            continue;
                        }
                        if ("servicePrincipalCredentialType".equals(fieldName)) {
                            deserializedWarehouseLinkedService.servicePrincipalCredentialType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalCredential".equals(fieldName)) {
                            deserializedWarehouseLinkedService.servicePrincipalCredential = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedWarehouseLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWarehouseLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedWarehouseLinkedService;
        });
    }
}

