/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.DatasetReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValidationActivity
extends ControlActivity {
    private String type = "Validation";
    private Object timeout;
    private Object sleep;
    private Object minimumSize;
    private Object childItems;
    private DatasetReference dataset;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getTimeout() {
        return this.timeout;
    }

    public ValidationActivity setTimeout(Object timeout) {
        this.timeout = timeout;
        return this;
    }

    public Object getSleep() {
        return this.sleep;
    }

    public ValidationActivity setSleep(Object sleep) {
        this.sleep = sleep;
        return this;
    }

    public Object getMinimumSize() {
        return this.minimumSize;
    }

    public ValidationActivity setMinimumSize(Object minimumSize) {
        this.minimumSize = minimumSize;
        return this;
    }

    public Object getChildItems() {
        return this.childItems;
    }

    public ValidationActivity setChildItems(Object childItems) {
        this.childItems = childItems;
        return this;
    }

    public DatasetReference getDataset() {
        return this.dataset;
    }

    public ValidationActivity setDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    @Override
    public ValidationActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ValidationActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ValidationActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public ValidationActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ValidationActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ValidationActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.timeout != null || this.sleep != null || this.minimumSize != null || this.childItems != null || this.dataset != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.timeout != null) {
                jsonWriter.writeUntypedField("timeout", this.timeout);
            }
            if (this.sleep != null) {
                jsonWriter.writeUntypedField("sleep", this.sleep);
            }
            if (this.minimumSize != null) {
                jsonWriter.writeUntypedField("minimumSize", this.minimumSize);
            }
            if (this.childItems != null) {
                jsonWriter.writeUntypedField("childItems", this.childItems);
            }
            jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ValidationActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationActivity)jsonReader.readObject(reader -> {
            ValidationActivity deserializedValidationActivity = new ValidationActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedValidationActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedValidationActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedValidationActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedValidationActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedValidationActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedValidationActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedValidationActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("timeout".equals(fieldName)) {
                            deserializedValidationActivity.timeout = reader.readUntyped();
                            continue;
                        }
                        if ("sleep".equals(fieldName)) {
                            deserializedValidationActivity.sleep = reader.readUntyped();
                            continue;
                        }
                        if ("minimumSize".equals(fieldName)) {
                            deserializedValidationActivity.minimumSize = reader.readUntyped();
                            continue;
                        }
                        if ("childItems".equals(fieldName)) {
                            deserializedValidationActivity.childItems = reader.readUntyped();
                            continue;
                        }
                        if ("dataset".equals(fieldName)) {
                            deserializedValidationActivity.dataset = DatasetReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedValidationActivity.setAdditionalProperties(additionalProperties);
            return deserializedValidationActivity;
        });
    }
}

