/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.TriggerRunStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TriggerRun
implements JsonSerializable<TriggerRun> {
    private String triggerRunId;
    private String triggerName;
    private String triggerType;
    private OffsetDateTime triggerRunTimestamp;
    private TriggerRunStatus status;
    private String message;
    private Map<String, String> properties;
    private Map<String, String> triggeredPipelines;
    private Map<String, Object> additionalProperties;

    public String getTriggerRunId() {
        return this.triggerRunId;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public String getTriggerType() {
        return this.triggerType;
    }

    public OffsetDateTime getTriggerRunTimestamp() {
        return this.triggerRunTimestamp;
    }

    public TriggerRunStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getTriggeredPipelines() {
        return this.triggeredPipelines;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public TriggerRun setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TriggerRun fromJson(JsonReader jsonReader) throws IOException {
        return (TriggerRun)jsonReader.readObject(reader -> {
            TriggerRun deserializedTriggerRun = new TriggerRun();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("triggerRunId".equals(fieldName)) {
                    deserializedTriggerRun.triggerRunId = reader.getString();
                    continue;
                }
                if ("triggerName".equals(fieldName)) {
                    deserializedTriggerRun.triggerName = reader.getString();
                    continue;
                }
                if ("triggerType".equals(fieldName)) {
                    deserializedTriggerRun.triggerType = reader.getString();
                    continue;
                }
                if ("triggerRunTimestamp".equals(fieldName)) {
                    deserializedTriggerRun.triggerRunTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTriggerRun.status = TriggerRunStatus.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedTriggerRun.message = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedTriggerRun.properties = properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("triggeredPipelines".equals(fieldName)) {
                    Map triggeredPipelines;
                    deserializedTriggerRun.triggeredPipelines = triggeredPipelines = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTriggerRun.additionalProperties = additionalProperties;
            return deserializedTriggerRun;
        });
    }
}

