/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.TeradataAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TeradataLinkedService
extends LinkedService {
    private String type = "Teradata";
    private Object connectionString;
    private Object server;
    private TeradataAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object sslMode;
    private Object portNumber;
    private Object httpsPortNumber;
    private Object useDataEncryption;
    private Object characterSet;
    private Object maxRespSize;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public TeradataLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getServer() {
        return this.server;
    }

    public TeradataLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public TeradataAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public TeradataLinkedService setAuthenticationType(TeradataAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public TeradataLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public TeradataLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getSslMode() {
        return this.sslMode;
    }

    public TeradataLinkedService setSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object getPortNumber() {
        return this.portNumber;
    }

    public TeradataLinkedService setPortNumber(Object portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public Object getHttpsPortNumber() {
        return this.httpsPortNumber;
    }

    public TeradataLinkedService setHttpsPortNumber(Object httpsPortNumber) {
        this.httpsPortNumber = httpsPortNumber;
        return this;
    }

    public Object getUseDataEncryption() {
        return this.useDataEncryption;
    }

    public TeradataLinkedService setUseDataEncryption(Object useDataEncryption) {
        this.useDataEncryption = useDataEncryption;
        return this;
    }

    public Object getCharacterSet() {
        return this.characterSet;
    }

    public TeradataLinkedService setCharacterSet(Object characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    public Object getMaxRespSize() {
        return this.maxRespSize;
    }

    public TeradataLinkedService setMaxRespSize(Object maxRespSize) {
        this.maxRespSize = maxRespSize;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public TeradataLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public TeradataLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public TeradataLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public TeradataLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public TeradataLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public TeradataLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.server != null || this.authenticationType != null || this.username != null || this.password != null || this.sslMode != null || this.portNumber != null || this.httpsPortNumber != null || this.useDataEncryption != null || this.characterSet != null || this.maxRespSize != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            if (this.server != null) {
                jsonWriter.writeUntypedField("server", this.server);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.sslMode != null) {
                jsonWriter.writeUntypedField("sslMode", this.sslMode);
            }
            if (this.portNumber != null) {
                jsonWriter.writeUntypedField("portNumber", this.portNumber);
            }
            if (this.httpsPortNumber != null) {
                jsonWriter.writeUntypedField("httpsPortNumber", this.httpsPortNumber);
            }
            if (this.useDataEncryption != null) {
                jsonWriter.writeUntypedField("useDataEncryption", this.useDataEncryption);
            }
            if (this.characterSet != null) {
                jsonWriter.writeUntypedField("characterSet", this.characterSet);
            }
            if (this.maxRespSize != null) {
                jsonWriter.writeUntypedField("maxRespSize", this.maxRespSize);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TeradataLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (TeradataLinkedService)jsonReader.readObject(reader -> {
            TeradataLinkedService deserializedTeradataLinkedService = new TeradataLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedTeradataLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedTeradataLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedTeradataLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedTeradataLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedTeradataLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTeradataLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedTeradataLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("server".equals(fieldName)) {
                            deserializedTeradataLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedTeradataLinkedService.authenticationType = TeradataAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedTeradataLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedTeradataLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("sslMode".equals(fieldName)) {
                            deserializedTeradataLinkedService.sslMode = reader.readUntyped();
                            continue;
                        }
                        if ("portNumber".equals(fieldName)) {
                            deserializedTeradataLinkedService.portNumber = reader.readUntyped();
                            continue;
                        }
                        if ("httpsPortNumber".equals(fieldName)) {
                            deserializedTeradataLinkedService.httpsPortNumber = reader.readUntyped();
                            continue;
                        }
                        if ("useDataEncryption".equals(fieldName)) {
                            deserializedTeradataLinkedService.useDataEncryption = reader.readUntyped();
                            continue;
                        }
                        if ("characterSet".equals(fieldName)) {
                            deserializedTeradataLinkedService.characterSet = reader.readUntyped();
                            continue;
                        }
                        if ("maxRespSize".equals(fieldName)) {
                            deserializedTeradataLinkedService.maxRespSize = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedTeradataLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTeradataLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedTeradataLinkedService;
        });
    }
}

