/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowResource;
import com.azure.analytics.synapse.artifacts.models.DatasetResource;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class StartDataFlowDebugSessionRequest
implements JsonSerializable<StartDataFlowDebugSessionRequest> {
    private String sessionId;
    private DataFlowResource dataFlow;
    private List<DataFlowResource> dataFlows;
    private List<DatasetResource> datasets;
    private List<LinkedServiceResource> linkedServices;
    private Object staging;
    private Object debugSettings;
    private Boolean incrementalDebug;

    public String getSessionId() {
        return this.sessionId;
    }

    public StartDataFlowDebugSessionRequest setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public DataFlowResource getDataFlow() {
        return this.dataFlow;
    }

    public StartDataFlowDebugSessionRequest setDataFlow(DataFlowResource dataFlow) {
        this.dataFlow = dataFlow;
        return this;
    }

    public List<DataFlowResource> getDataFlows() {
        return this.dataFlows;
    }

    public StartDataFlowDebugSessionRequest setDataFlows(List<DataFlowResource> dataFlows) {
        this.dataFlows = dataFlows;
        return this;
    }

    public List<DatasetResource> getDatasets() {
        return this.datasets;
    }

    public StartDataFlowDebugSessionRequest setDatasets(List<DatasetResource> datasets) {
        this.datasets = datasets;
        return this;
    }

    public List<LinkedServiceResource> getLinkedServices() {
        return this.linkedServices;
    }

    public StartDataFlowDebugSessionRequest setLinkedServices(List<LinkedServiceResource> linkedServices) {
        this.linkedServices = linkedServices;
        return this;
    }

    public Object getStaging() {
        return this.staging;
    }

    public StartDataFlowDebugSessionRequest setStaging(Object staging) {
        this.staging = staging;
        return this;
    }

    public Object getDebugSettings() {
        return this.debugSettings;
    }

    public StartDataFlowDebugSessionRequest setDebugSettings(Object debugSettings) {
        this.debugSettings = debugSettings;
        return this;
    }

    public Boolean isIncrementalDebug() {
        return this.incrementalDebug;
    }

    public StartDataFlowDebugSessionRequest setIncrementalDebug(Boolean incrementalDebug) {
        this.incrementalDebug = incrementalDebug;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sessionId", this.sessionId);
        jsonWriter.writeJsonField("dataFlow", (JsonSerializable)this.dataFlow);
        jsonWriter.writeArrayField("dataFlows", this.dataFlows, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("datasets", this.datasets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedServices", this.linkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.staging != null) {
            jsonWriter.writeUntypedField("staging", this.staging);
        }
        if (this.debugSettings != null) {
            jsonWriter.writeUntypedField("debugSettings", this.debugSettings);
        }
        jsonWriter.writeBooleanField("incrementalDebug", this.incrementalDebug);
        return jsonWriter.writeEndObject();
    }

    public static StartDataFlowDebugSessionRequest fromJson(JsonReader jsonReader) throws IOException {
        return (StartDataFlowDebugSessionRequest)jsonReader.readObject(reader -> {
            StartDataFlowDebugSessionRequest deserializedStartDataFlowDebugSessionRequest = new StartDataFlowDebugSessionRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sessionId".equals(fieldName)) {
                    deserializedStartDataFlowDebugSessionRequest.sessionId = reader.getString();
                    continue;
                }
                if ("dataFlow".equals(fieldName)) {
                    deserializedStartDataFlowDebugSessionRequest.dataFlow = DataFlowResource.fromJson(reader);
                    continue;
                }
                if ("dataFlows".equals(fieldName)) {
                    List dataFlows;
                    deserializedStartDataFlowDebugSessionRequest.dataFlows = dataFlows = reader.readArray(reader1 -> DataFlowResource.fromJson(reader1));
                    continue;
                }
                if ("datasets".equals(fieldName)) {
                    List datasets;
                    deserializedStartDataFlowDebugSessionRequest.datasets = datasets = reader.readArray(reader1 -> DatasetResource.fromJson(reader1));
                    continue;
                }
                if ("linkedServices".equals(fieldName)) {
                    List linkedServices;
                    deserializedStartDataFlowDebugSessionRequest.linkedServices = linkedServices = reader.readArray(reader1 -> LinkedServiceResource.fromJson(reader1));
                    continue;
                }
                if ("staging".equals(fieldName)) {
                    deserializedStartDataFlowDebugSessionRequest.staging = reader.readUntyped();
                    continue;
                }
                if ("debugSettings".equals(fieldName)) {
                    deserializedStartDataFlowDebugSessionRequest.debugSettings = reader.readUntyped();
                    continue;
                }
                if ("incrementalDebug".equals(fieldName)) {
                    deserializedStartDataFlowDebugSessionRequest.incrementalDebug = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStartDataFlowDebugSessionRequest;
        });
    }
}

