/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SqlServerStoredProcedureActivity
extends ExecutionActivity {
    private String type = "SqlServerStoredProcedure";
    private Object storedProcedureName;
    private Object storedProcedureParameters;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getStoredProcedureName() {
        return this.storedProcedureName;
    }

    public SqlServerStoredProcedureActivity setStoredProcedureName(Object storedProcedureName) {
        this.storedProcedureName = storedProcedureName;
        return this;
    }

    public Object getStoredProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public SqlServerStoredProcedureActivity setStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.storedProcedureName != null || this.storedProcedureParameters != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("storedProcedureName", this.storedProcedureName);
            if (this.storedProcedureParameters != null) {
                jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlServerStoredProcedureActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SqlServerStoredProcedureActivity)jsonReader.readObject(reader -> {
            SqlServerStoredProcedureActivity deserializedSqlServerStoredProcedureActivity = new SqlServerStoredProcedureActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSqlServerStoredProcedureActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSqlServerStoredProcedureActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("storedProcedureName".equals(fieldName)) {
                            deserializedSqlServerStoredProcedureActivity.storedProcedureName = reader.readUntyped();
                            continue;
                        }
                        if ("storedProcedureParameters".equals(fieldName)) {
                            deserializedSqlServerStoredProcedureActivity.storedProcedureParameters = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlServerStoredProcedureActivity.setAdditionalProperties(additionalProperties);
            return deserializedSqlServerStoredProcedureActivity;
        });
    }
}

