/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SqlConnection;
import com.azure.analytics.synapse.artifacts.models.SqlScriptMetadata;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SqlScriptContent
implements JsonSerializable<SqlScriptContent> {
    private String query;
    private SqlConnection currentConnection;
    private Integer resultLimit;
    private SqlScriptMetadata metadata;
    private Map<String, Object> additionalProperties;

    public String getQuery() {
        return this.query;
    }

    public SqlScriptContent setQuery(String query) {
        this.query = query;
        return this;
    }

    public SqlConnection getCurrentConnection() {
        return this.currentConnection;
    }

    public SqlScriptContent setCurrentConnection(SqlConnection currentConnection) {
        this.currentConnection = currentConnection;
        return this;
    }

    public Integer getResultLimit() {
        return this.resultLimit;
    }

    public SqlScriptContent setResultLimit(Integer resultLimit) {
        this.resultLimit = resultLimit;
        return this;
    }

    public SqlScriptMetadata getMetadata() {
        return this.metadata;
    }

    public SqlScriptContent setMetadata(SqlScriptMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SqlScriptContent setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeJsonField("currentConnection", (JsonSerializable)this.currentConnection);
        jsonWriter.writeNumberField("resultLimit", (Number)this.resultLimit);
        jsonWriter.writeJsonField("metadata", (JsonSerializable)this.metadata);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlScriptContent fromJson(JsonReader jsonReader) throws IOException {
        return (SqlScriptContent)jsonReader.readObject(reader -> {
            SqlScriptContent deserializedSqlScriptContent = new SqlScriptContent();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("query".equals(fieldName)) {
                    deserializedSqlScriptContent.query = reader.getString();
                    continue;
                }
                if ("currentConnection".equals(fieldName)) {
                    deserializedSqlScriptContent.currentConnection = SqlConnection.fromJson(reader);
                    continue;
                }
                if ("resultLimit".equals(fieldName)) {
                    deserializedSqlScriptContent.resultLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedSqlScriptContent.metadata = SqlScriptMetadata.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlScriptContent.additionalProperties = additionalProperties;
            return deserializedSqlScriptContent;
        });
    }
}

