/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.SftpAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SftpServerLinkedService
extends LinkedService {
    private String type = "Sftp";
    private Object host;
    private Object port;
    private SftpAuthenticationType authenticationType;
    private Object userName;
    private SecretBase password;
    private Object encryptedCredential;
    private Object privateKeyPath;
    private SecretBase privateKeyContent;
    private SecretBase passPhrase;
    private Object skipHostKeyValidation;
    private Object hostKeyFingerprint;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getHost() {
        return this.host;
    }

    public SftpServerLinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public SftpServerLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public SftpAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public SftpServerLinkedService setAuthenticationType(SftpAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public SftpServerLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SftpServerLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SftpServerLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public SftpServerLinkedService setPrivateKeyPath(Object privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    public SecretBase getPrivateKeyContent() {
        return this.privateKeyContent;
    }

    public SftpServerLinkedService setPrivateKeyContent(SecretBase privateKeyContent) {
        this.privateKeyContent = privateKeyContent;
        return this;
    }

    public SecretBase getPassPhrase() {
        return this.passPhrase;
    }

    public SftpServerLinkedService setPassPhrase(SecretBase passPhrase) {
        this.passPhrase = passPhrase;
        return this;
    }

    public Object getSkipHostKeyValidation() {
        return this.skipHostKeyValidation;
    }

    public SftpServerLinkedService setSkipHostKeyValidation(Object skipHostKeyValidation) {
        this.skipHostKeyValidation = skipHostKeyValidation;
        return this;
    }

    public Object getHostKeyFingerprint() {
        return this.hostKeyFingerprint;
    }

    public SftpServerLinkedService setHostKeyFingerprint(Object hostKeyFingerprint) {
        this.hostKeyFingerprint = hostKeyFingerprint;
        return this;
    }

    @Override
    public SftpServerLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SftpServerLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SftpServerLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SftpServerLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SftpServerLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.host != null || this.port != null || this.authenticationType != null || this.userName != null || this.password != null || this.encryptedCredential != null || this.privateKeyPath != null || this.privateKeyContent != null || this.passPhrase != null || this.skipHostKeyValidation != null || this.hostKeyFingerprint != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("host", this.host);
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.privateKeyPath != null) {
                jsonWriter.writeUntypedField("privateKeyPath", this.privateKeyPath);
            }
            jsonWriter.writeJsonField("privateKeyContent", (JsonSerializable)this.privateKeyContent);
            jsonWriter.writeJsonField("passPhrase", (JsonSerializable)this.passPhrase);
            if (this.skipHostKeyValidation != null) {
                jsonWriter.writeUntypedField("skipHostKeyValidation", this.skipHostKeyValidation);
            }
            if (this.hostKeyFingerprint != null) {
                jsonWriter.writeUntypedField("hostKeyFingerprint", this.hostKeyFingerprint);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SftpServerLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SftpServerLinkedService)jsonReader.readObject(reader -> {
            SftpServerLinkedService deserializedSftpServerLinkedService = new SftpServerLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSftpServerLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSftpServerLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSftpServerLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSftpServerLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSftpServerLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSftpServerLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("host".equals(fieldName)) {
                            deserializedSftpServerLinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedSftpServerLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedSftpServerLinkedService.authenticationType = SftpAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedSftpServerLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSftpServerLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSftpServerLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("privateKeyPath".equals(fieldName)) {
                            deserializedSftpServerLinkedService.privateKeyPath = reader.readUntyped();
                            continue;
                        }
                        if ("privateKeyContent".equals(fieldName)) {
                            deserializedSftpServerLinkedService.privateKeyContent = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("passPhrase".equals(fieldName)) {
                            deserializedSftpServerLinkedService.passPhrase = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("skipHostKeyValidation".equals(fieldName)) {
                            deserializedSftpServerLinkedService.skipHostKeyValidation = reader.readUntyped();
                            continue;
                        }
                        if ("hostKeyFingerprint".equals(fieldName)) {
                            deserializedSftpServerLinkedService.hostKeyFingerprint = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSftpServerLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSftpServerLinkedService;
        });
    }
}

