/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.SecureInputOutputPolicy;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SetVariableActivity
extends ControlActivity {
    private String type = "SetVariable";
    private SecureInputOutputPolicy policy;
    private String variableName;
    private Object value;
    private Boolean setSystemVariable;

    @Override
    public String getType() {
        return this.type;
    }

    public SecureInputOutputPolicy getPolicy() {
        return this.policy;
    }

    public SetVariableActivity setPolicy(SecureInputOutputPolicy policy) {
        this.policy = policy;
        return this;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public SetVariableActivity setVariableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public SetVariableActivity setValue(Object value) {
        this.value = value;
        return this;
    }

    public Boolean isSetSystemVariable() {
        return this.setSystemVariable;
    }

    public SetVariableActivity setSetSystemVariable(Boolean setSystemVariable) {
        this.setSystemVariable = setSystemVariable;
        return this;
    }

    @Override
    public SetVariableActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public SetVariableActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SetVariableActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public SetVariableActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SetVariableActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SetVariableActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        if (this.variableName != null || this.value != null || this.setSystemVariable != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeStringField("variableName", this.variableName);
            if (this.value != null) {
                jsonWriter.writeUntypedField("value", this.value);
            }
            jsonWriter.writeBooleanField("setSystemVariable", this.setSystemVariable);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SetVariableActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SetVariableActivity)jsonReader.readObject(reader -> {
            SetVariableActivity deserializedSetVariableActivity = new SetVariableActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSetVariableActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSetVariableActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSetVariableActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSetVariableActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSetVariableActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSetVariableActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSetVariableActivity.type = reader.getString();
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedSetVariableActivity.policy = SecureInputOutputPolicy.fromJson(reader);
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("variableName".equals(fieldName)) {
                            deserializedSetVariableActivity.variableName = reader.getString();
                            continue;
                        }
                        if ("value".equals(fieldName)) {
                            deserializedSetVariableActivity.value = reader.readUntyped();
                            continue;
                        }
                        if ("setSystemVariable".equals(fieldName)) {
                            deserializedSetVariableActivity.setSystemVariable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSetVariableActivity.setAdditionalProperties(additionalProperties);
            return deserializedSetVariableActivity;
        });
    }
}

