/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SapOdpSource
extends TabularSource {
    private String type = "SapOdpSource";
    private Object extractionMode;
    private Object subscriberProcess;
    private Object selection;
    private Object projection;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getExtractionMode() {
        return this.extractionMode;
    }

    public SapOdpSource setExtractionMode(Object extractionMode) {
        this.extractionMode = extractionMode;
        return this;
    }

    public Object getSubscriberProcess() {
        return this.subscriberProcess;
    }

    public SapOdpSource setSubscriberProcess(Object subscriberProcess) {
        this.subscriberProcess = subscriberProcess;
        return this;
    }

    public Object getSelection() {
        return this.selection;
    }

    public SapOdpSource setSelection(Object selection) {
        this.selection = selection;
        return this;
    }

    public Object getProjection() {
        return this.projection;
    }

    public SapOdpSource setProjection(Object projection) {
        this.projection = projection;
        return this;
    }

    @Override
    public SapOdpSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public SapOdpSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public SapOdpSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SapOdpSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SapOdpSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.extractionMode != null) {
            jsonWriter.writeUntypedField("extractionMode", this.extractionMode);
        }
        if (this.subscriberProcess != null) {
            jsonWriter.writeUntypedField("subscriberProcess", this.subscriberProcess);
        }
        if (this.selection != null) {
            jsonWriter.writeUntypedField("selection", this.selection);
        }
        if (this.projection != null) {
            jsonWriter.writeUntypedField("projection", this.projection);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapOdpSource fromJson(JsonReader jsonReader) throws IOException {
        return (SapOdpSource)jsonReader.readObject(reader -> {
            SapOdpSource deserializedSapOdpSource = new SapOdpSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSapOdpSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSapOdpSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSapOdpSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedSapOdpSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSapOdpSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapOdpSource.type = reader.getString();
                    continue;
                }
                if ("extractionMode".equals(fieldName)) {
                    deserializedSapOdpSource.extractionMode = reader.readUntyped();
                    continue;
                }
                if ("subscriberProcess".equals(fieldName)) {
                    deserializedSapOdpSource.subscriberProcess = reader.readUntyped();
                    continue;
                }
                if ("selection".equals(fieldName)) {
                    deserializedSapOdpSource.selection = reader.readUntyped();
                    continue;
                }
                if ("projection".equals(fieldName)) {
                    deserializedSapOdpSource.projection = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapOdpSource.setAdditionalProperties(additionalProperties);
            return deserializedSapOdpSource;
        });
    }
}

