/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SapHanaAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SapHanaLinkedService
extends LinkedService {
    private String type = "SapHana";
    private Object connectionString;
    private Object server;
    private SapHanaAuthenticationType authenticationType;
    private Object userName;
    private SecretBase password;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public SapHanaLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getServer() {
        return this.server;
    }

    public SapHanaLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public SapHanaAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public SapHanaLinkedService setAuthenticationType(SapHanaAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public SapHanaLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SapHanaLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SapHanaLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SapHanaLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SapHanaLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SapHanaLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SapHanaLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SapHanaLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.server != null || this.authenticationType != null || this.userName != null || this.password != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            jsonWriter.writeUntypedField("server", this.server);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapHanaLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SapHanaLinkedService)jsonReader.readObject(reader -> {
            SapHanaLinkedService deserializedSapHanaLinkedService = new SapHanaLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSapHanaLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSapHanaLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapHanaLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapHanaLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapHanaLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapHanaLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedSapHanaLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("server".equals(fieldName)) {
                            deserializedSapHanaLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedSapHanaLinkedService.authenticationType = SapHanaAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedSapHanaLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSapHanaLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSapHanaLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapHanaLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSapHanaLinkedService;
        });
    }
}

