/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.analytics.synapse.artifacts.models.SapCloudForCustomerSinkWriteBehavior;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SapCloudForCustomerSink
extends CopySink {
    private String type = "SapCloudForCustomerSink";
    private SapCloudForCustomerSinkWriteBehavior writeBehavior;
    private Object httpRequestTimeout;

    @Override
    public String getType() {
        return this.type;
    }

    public SapCloudForCustomerSinkWriteBehavior getWriteBehavior() {
        return this.writeBehavior;
    }

    public SapCloudForCustomerSink setWriteBehavior(SapCloudForCustomerSinkWriteBehavior writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public Object getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public SapCloudForCustomerSink setHttpRequestTimeout(Object httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    @Override
    public SapCloudForCustomerSink setWriteBatchSize(Object writeBatchSize) {
        super.setWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SapCloudForCustomerSink setWriteBatchTimeout(Object writeBatchTimeout) {
        super.setWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SapCloudForCustomerSink setSinkRetryCount(Object sinkRetryCount) {
        super.setSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SapCloudForCustomerSink setSinkRetryWait(Object sinkRetryWait) {
        super.setSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SapCloudForCustomerSink setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getWriteBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.getWriteBatchSize());
        }
        if (this.getWriteBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.getWriteBatchTimeout());
        }
        if (this.getSinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.getSinkRetryCount());
        }
        if (this.getSinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.getSinkRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("writeBehavior", this.writeBehavior == null ? null : this.writeBehavior.toString());
        if (this.httpRequestTimeout != null) {
            jsonWriter.writeUntypedField("httpRequestTimeout", this.httpRequestTimeout);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapCloudForCustomerSink fromJson(JsonReader jsonReader) throws IOException {
        return (SapCloudForCustomerSink)jsonReader.readObject(reader -> {
            SapCloudForCustomerSink deserializedSapCloudForCustomerSink = new SapCloudForCustomerSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSapCloudForCustomerSink.setWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSapCloudForCustomerSink.setWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSapCloudForCustomerSink.setSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSapCloudForCustomerSink.setSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSapCloudForCustomerSink.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapCloudForCustomerSink.type = reader.getString();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedSapCloudForCustomerSink.writeBehavior = SapCloudForCustomerSinkWriteBehavior.fromString(reader.getString());
                    continue;
                }
                if ("httpRequestTimeout".equals(fieldName)) {
                    deserializedSapCloudForCustomerSink.httpRequestTimeout = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapCloudForCustomerSink.setAdditionalProperties(additionalProperties);
            return deserializedSapCloudForCustomerSink;
        });
    }
}

