/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SapCloudForCustomerLinkedService
extends LinkedService {
    private String type = "SapCloudForCustomer";
    private Object url;
    private Object username;
    private SecretBase password;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getUrl() {
        return this.url;
    }

    public SapCloudForCustomerLinkedService setUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public SapCloudForCustomerLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SapCloudForCustomerLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SapCloudForCustomerLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SapCloudForCustomerLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SapCloudForCustomerLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SapCloudForCustomerLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SapCloudForCustomerLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SapCloudForCustomerLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.url != null || this.username != null || this.password != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("url", this.url);
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapCloudForCustomerLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SapCloudForCustomerLinkedService)jsonReader.readObject(reader -> {
            SapCloudForCustomerLinkedService deserializedSapCloudForCustomerLinkedService = new SapCloudForCustomerLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSapCloudForCustomerLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSapCloudForCustomerLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapCloudForCustomerLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapCloudForCustomerLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapCloudForCustomerLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapCloudForCustomerLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("url".equals(fieldName)) {
                            deserializedSapCloudForCustomerLinkedService.url = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedSapCloudForCustomerLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSapCloudForCustomerLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSapCloudForCustomerLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapCloudForCustomerLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSapCloudForCustomerLinkedService;
        });
    }
}

