/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SalesforceServiceCloudV2Source
extends CopySource {
    private String type = "SalesforceServiceCloudV2Source";
    private Object soqlQuery;
    private Object query;
    private Object includeDeletedObjects;
    private Object additionalColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getSoqlQuery() {
        return this.soqlQuery;
    }

    public SalesforceServiceCloudV2Source setSoqlQuery(Object soqlQuery) {
        this.soqlQuery = soqlQuery;
        return this;
    }

    public Object getQuery() {
        return this.query;
    }

    public SalesforceServiceCloudV2Source setQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object getIncludeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    public SalesforceServiceCloudV2Source setIncludeDeletedObjects(Object includeDeletedObjects) {
        this.includeDeletedObjects = includeDeletedObjects;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public SalesforceServiceCloudV2Source setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Source setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Source setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2Source setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.soqlQuery != null) {
            jsonWriter.writeUntypedField("SOQLQuery", this.soqlQuery);
        }
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.includeDeletedObjects != null) {
            jsonWriter.writeUntypedField("includeDeletedObjects", this.includeDeletedObjects);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceServiceCloudV2Source fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceServiceCloudV2Source)jsonReader.readObject(reader -> {
            SalesforceServiceCloudV2Source deserializedSalesforceServiceCloudV2Source = new SalesforceServiceCloudV2Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.type = reader.getString();
                    continue;
                }
                if ("SOQLQuery".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.soqlQuery = reader.readUntyped();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.query = reader.readUntyped();
                    continue;
                }
                if ("includeDeletedObjects".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.includeDeletedObjects = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2Source.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceServiceCloudV2Source.setAdditionalProperties(additionalProperties);
            return deserializedSalesforceServiceCloudV2Source;
        });
    }
}

