/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SalesforceLinkedService
extends LinkedService {
    private String type = "Salesforce";
    private Object environmentUrl;
    private Object username;
    private SecretBase password;
    private SecretBase securityToken;
    private Object apiVersion;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEnvironmentUrl() {
        return this.environmentUrl;
    }

    public SalesforceLinkedService setEnvironmentUrl(Object environmentUrl) {
        this.environmentUrl = environmentUrl;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public SalesforceLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SalesforceLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public SecretBase getSecurityToken() {
        return this.securityToken;
    }

    public SalesforceLinkedService setSecurityToken(SecretBase securityToken) {
        this.securityToken = securityToken;
        return this;
    }

    public Object getApiVersion() {
        return this.apiVersion;
    }

    public SalesforceLinkedService setApiVersion(Object apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SalesforceLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SalesforceLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SalesforceLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SalesforceLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SalesforceLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SalesforceLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.environmentUrl != null || this.username != null || this.password != null || this.securityToken != null || this.apiVersion != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.environmentUrl != null) {
                jsonWriter.writeUntypedField("environmentUrl", this.environmentUrl);
            }
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            jsonWriter.writeJsonField("securityToken", (JsonSerializable)this.securityToken);
            if (this.apiVersion != null) {
                jsonWriter.writeUntypedField("apiVersion", this.apiVersion);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceLinkedService)jsonReader.readObject(reader -> {
            SalesforceLinkedService deserializedSalesforceLinkedService = new SalesforceLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSalesforceLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSalesforceLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSalesforceLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSalesforceLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSalesforceLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("environmentUrl".equals(fieldName)) {
                            deserializedSalesforceLinkedService.environmentUrl = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedSalesforceLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSalesforceLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("securityToken".equals(fieldName)) {
                            deserializedSalesforceLinkedService.securityToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("apiVersion".equals(fieldName)) {
                            deserializedSalesforceLinkedService.apiVersion = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSalesforceLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSalesforceLinkedService;
        });
    }
}

